/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.base.Pair;
import de.setsoftware.reviewtool.base.ReviewtoolException;
import de.setsoftware.reviewtool.model.api.IFileDiff;
import de.setsoftware.reviewtool.model.api.IFileHistoryEdge;
import de.setsoftware.reviewtool.model.api.IFragment;
import de.setsoftware.reviewtool.model.api.IHunk;
import de.setsoftware.reviewtool.model.api.IncompatibleFragmentException;
import de.setsoftware.reviewtool.model.changestructure.ChangestructureFactory;
import de.setsoftware.reviewtool.model.changestructure.FileDiff;
import de.setsoftware.reviewtool.model.changestructure.FileHistoryEdgeProxy;
import de.setsoftware.reviewtool.model.changestructure.FileHistoryGraph;
import de.setsoftware.reviewtool.model.changestructure.ProxyableFileHistoryEdge;
import de.setsoftware.reviewtool.model.changestructure.ProxyableFileHistoryNode;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

final class FileHistoryEdge
extends ProxyableFileHistoryEdge {
    private static final long serialVersionUID = 2504351095940964539L;
    private final FileHistoryGraph graph;
    private final ProxyableFileHistoryNode ancestor;
    private final ProxyableFileHistoryNode descendant;
    private IFileHistoryEdge.Type type;
    private IFileDiff diff;

    FileHistoryEdge(FileHistoryGraph graph, ProxyableFileHistoryNode ancestor, ProxyableFileHistoryNode descendant, IFileHistoryEdge.Type type) {
        this.graph = graph;
        this.ancestor = ancestor;
        this.descendant = descendant;
        this.type = type;
    }

    @Override
    public FileHistoryGraph getGraph() {
        return this.graph;
    }

    @Override
    public ProxyableFileHistoryNode getAncestor() {
        return this.ancestor;
    }

    @Override
    public ProxyableFileHistoryNode getDescendant() {
        return this.descendant;
    }

    @Override
    public IFileHistoryEdge.Type getType() {
        return this.type;
    }

    @Override
    void setType(IFileHistoryEdge.Type type) {
        this.type = type;
    }

    @Override
    public IFileDiff getDiff() {
        if (this.diff == null) {
            this.diff = this.computeDiff();
        }
        return this.diff;
    }

    public boolean equals(Object o) {
        if (o instanceof FileHistoryEdge) {
            FileHistoryEdge other = (FileHistoryEdge)o;
            return this.ancestor.equals(other.ancestor) && this.descendant.equals(other.descendant) && this.type.equals((Object)other.type);
        }
        return false;
    }

    public int hashCode() {
        return this.ancestor.hashCode() ^ this.descendant.hashCode();
    }

    private IFileDiff computeDiff() {
        byte[] newFileContents;
        byte[] oldFileContents;
        try {
            oldFileContents = this.ancestor.getFile().getContents();
            newFileContents = this.descendant.getFile().getContents();
        }
        catch (Exception e) {
            throw new ReviewtoolException(e);
        }
        List<Pair<IFragment, IFragment>> textChanges = this.graph.getDiffAlgorithm().determineDiff(this.ancestor.getFile(), oldFileContents, this.descendant.getFile(), newFileContents, this.guessEncoding(oldFileContents, newFileContents));
        ArrayList<IHunk> hunks = new ArrayList<IHunk>();
        for (Pair<IFragment, IFragment> pos : textChanges) {
            hunks.add(ChangestructureFactory.createHunk(pos.getFirst(), pos.getSecond()));
        }
        try {
            return new FileDiff(this.ancestor.getFile(), this.descendant.getFile()).merge(hunks);
        }
        catch (IncompatibleFragmentException e) {
            throw new ReviewtoolException(e);
        }
    }

    private String guessEncoding(byte[] oldFileContent, byte[] newFileContent) {
        if (this.isValidUtf8(oldFileContent) && this.isValidUtf8(newFileContent)) {
            return "UTF-8";
        }
        return "ISO-8859-1";
    }

    private boolean isValidUtf8(byte[] content) {
        try {
            StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT).decode(ByteBuffer.wrap(content));
            return true;
        }
        catch (CharacterCodingException e) {
            return false;
        }
    }

    protected final Object writeReplace() {
        return new FileHistoryEdgeProxy(this.graph, this.ancestor.getFile(), this.descendant.getFile(), this.type);
    }
}

