/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.model.api.IChangeData;
import de.setsoftware.reviewtool.model.api.ICommit;
import de.setsoftware.reviewtool.model.api.IRepository;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class ChangeData
implements IChangeData {
    private final List<? extends ICommit> commits;
    private final Set<IRepository> repositories;

    ChangeData(List<? extends ICommit> commits) {
        this.commits = commits;
        this.commits.sort((Comparator<? extends ICommit>)new Comparator<ICommit>(){

            @Override
            public int compare(ICommit o1, ICommit o2) {
                return o1.getTime().compareTo(o2.getTime());
            }
        });
        this.repositories = new LinkedHashSet<IRepository>();
        for (ICommit iCommit : this.commits) {
            this.repositories.add(iCommit.getRevision().getRepository());
        }
    }

    @Override
    public Set<? extends IRepository> getRepositories() {
        return Collections.unmodifiableSet(this.repositories);
    }

    @Override
    public List<? extends ICommit> getMatchedCommits() {
        return Collections.unmodifiableList(this.commits);
    }
}

