/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.base.PartialOrderAlgorithms;
import de.setsoftware.reviewtool.model.api.IFileHistoryEdge;
import de.setsoftware.reviewtool.model.api.IFileHistoryGraph;
import de.setsoftware.reviewtool.model.api.IFileHistoryNode;
import de.setsoftware.reviewtool.model.api.ILocalRevision;
import de.setsoftware.reviewtool.model.api.IRepoRevision;
import de.setsoftware.reviewtool.model.api.IRevisionVisitor;
import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import de.setsoftware.reviewtool.model.api.IUnknownRevision;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractFileHistoryGraph
implements IFileHistoryGraph {
    @Override
    public final synchronized List<IRevisionedFile> getLatestFiles(IRevisionedFile file, boolean ignoreNonLocalCopies) {
        Set<IFileHistoryNode> nodes = this.getLatestFilesHelper(file, ignoreNonLocalCopies, false);
        if (nodes.isEmpty()) {
            nodes = this.getLatestFilesHelper(file, ignoreNonLocalCopies, true);
        }
        if (nodes.isEmpty()) {
            return Collections.singletonList(file);
        }
        ArrayList<IRevisionedFile> revs = new ArrayList<IRevisionedFile>();
        for (IFileHistoryNode node : nodes) {
            revs.add(node.getFile());
        }
        return PartialOrderAlgorithms.topoSort(revs);
    }

    private Set<IFileHistoryNode> getLatestFilesHelper(IRevisionedFile file, boolean ignoreNonLocalCopies, boolean returnDeletions) {
        IFileHistoryNode node = this.getNodeFor(file);
        if (node == null) {
            return Collections.emptySet();
        }
        return this.getLatestFilesHelper(node, ignoreNonLocalCopies, returnDeletions);
    }

    private Set<IFileHistoryNode> getLatestFilesHelper(IFileHistoryNode node, boolean ignoreNonLocalCopies, final boolean returnDeletions) {
        if (!node.getType().equals((Object)IFileHistoryNode.Type.DELETED)) {
            if (node.getDescendants().isEmpty()) {
                return Collections.singleton(node);
            }
            final LinkedHashSet<IFileHistoryNode> result = new LinkedHashSet<IFileHistoryNode>();
            boolean samePathFound = false;
            for (IFileHistoryEdge iFileHistoryEdge : node.getDescendants()) {
                final IFileHistoryNode descendant = iFileHistoryEdge.getDescendant();
                if (node.getFile().getPath().equals(descendant.getFile().getPath())) {
                    samePathFound = true;
                    result.addAll(this.getLatestFilesHelper(descendant, ignoreNonLocalCopies, returnDeletions));
                    continue;
                }
                if (!ignoreNonLocalCopies) {
                    result.addAll(this.getLatestFilesHelper(descendant, false, returnDeletions));
                    continue;
                }
                descendant.getFile().getRevision().accept(new IRevisionVisitor<Void>(){

                    @Override
                    public Void handleLocalRevision(ILocalRevision revision) {
                        result.addAll(AbstractFileHistoryGraph.this.getLatestFilesHelper(descendant, true, returnDeletions));
                        return null;
                    }

                    @Override
                    public Void handleRepoRevision(IRepoRevision<?> revision) {
                        return null;
                    }

                    @Override
                    public Void handleUnknownRevision(IUnknownRevision revision) {
                        return null;
                    }
                });
            }
            if (!samePathFound || returnDeletions && result.isEmpty()) {
                result.add(node);
            }
            return result;
        }
        return Collections.emptySet();
    }
}

