/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.api;

import de.setsoftware.reviewtool.model.api.ICortProgressMonitor;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class BackgroundJobExecutor {
    private static BackgroundJobExecutor instance;

    public static void setInstance(BackgroundJobExecutor inst) {
        instance = inst;
    }

    public static void execute(String name, Function<ICortProgressMonitor, Throwable> job) {
        BackgroundJobExecutor.executeWithMutex(name, null, job);
    }

    public static void execute(String name, Consumer<ICortProgressMonitor> job) {
        BackgroundJobExecutor.executeWithMutex(name, null, job);
    }

    public static void executeWithMutex(String name, Object mutexResource, Function<ICortProgressMonitor, Throwable> job) {
        BackgroundJobExecutor.executeWithMutex(name, mutexResource, job, -1L);
    }

    public static void executeWithMutex(String name, Object mutexResource, Consumer<ICortProgressMonitor> job, long processingDelay) {
        BackgroundJobExecutor.executeWithMutex(name, mutexResource, BackgroundJobExecutor.wrap(job), processingDelay);
    }

    public static void executeWithMutex(String name, Object mutexResource, Function<ICortProgressMonitor, Throwable> job, long processingDelay) {
        instance.startJob(name, mutexResource, job, processingDelay);
    }

    public static void executeWithMutex(String name, Object mutexResource, Consumer<ICortProgressMonitor> job) {
        BackgroundJobExecutor.executeWithMutex(name, mutexResource, BackgroundJobExecutor.wrap(job));
    }

    private static Function<ICortProgressMonitor, Throwable> wrap(Consumer<ICortProgressMonitor> job) {
        return m -> {
            job.accept((ICortProgressMonitor)m);
            return null;
        };
    }

    protected abstract void startJob(String var1, Object var2, Function<ICortProgressMonitor, Throwable> var3, long var4);

    public static RuntimeException createOperationCanceledException() {
        if (instance == null) {
            return new RuntimeException("operation cancelled on uninitialized BackgroundJobExecutor");
        }
        return instance.doCreateOperationCanceledException();
    }

    protected abstract RuntimeException doCreateOperationCanceledException();
}

