/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.base.tree;

import de.setsoftware.reviewtool.base.tree.AbstractTreeNode;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class OrderPreservingTreeNode<K extends Comparable<K>, V>
extends AbstractTreeNode<K, V, OrderPreservingTreeNode<K, V>> {
    private static final long serialVersionUID = 168352569852009515L;
    private final LinkedHashMap<K, OrderPreservingTreeNode<K, V>> children = new LinkedHashMap();

    private OrderPreservingTreeNode(OrderPreservingTreeNode<K, V> parent, V value) {
        super(parent, value);
    }

    public static <K extends Comparable<K>, V> OrderPreservingTreeNode<K, V> createRoot(V value) {
        return new OrderPreservingTreeNode<K, V>(null, value);
    }

    @Override
    public OrderPreservingTreeNode<K, V> getNode(K key) {
        return this.children.get(key);
    }

    @Override
    public OrderPreservingTreeNode<K, V> putValue(K key, V value) {
        OrderPreservingTreeNode<K, V> child = this.children.get(key);
        if (child == null) {
            child = new OrderPreservingTreeNode<K, V>(this, value);
            this.children.put(key, child);
        } else {
            child.setValue(value);
        }
        return child;
    }

    @Override
    public Set<Map.Entry<K, OrderPreservingTreeNode<K, V>>> getEntries() {
        return Collections.unmodifiableSet(this.children.entrySet());
    }

    @Override
    public void removeNode(OrderPreservingTreeNode<K, V> childNode) {
        this.children.values().remove(childNode);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OrderPreservingTreeNode) {
            return super.equals(obj);
        }
        return false;
    }

    @Override
    protected OrderPreservingTreeNode<K, V> getSelf() {
        return this;
    }
}

