/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.ticketconnectors.file;

import de.setsoftware.reviewtool.base.ReviewtoolException;
import de.setsoftware.reviewtool.model.EndTransition;
import de.setsoftware.reviewtool.model.ITicketConnector;
import de.setsoftware.reviewtool.model.ITicketData;
import de.setsoftware.reviewtool.model.TicketInfo;
import de.setsoftware.reviewtool.model.TicketLinkSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class FilePersistence
implements ITicketConnector {
    private static final String REVIEW_DATA_TXT = "reviewData.txt";
    private static final String REVIEW_HISTORY_TXT = "reviewHistory.txt";
    private static final String STATE_PREFIX = "state.";
    private static final String IN_IMPLEMENTATION = "inImplementation";
    private static final String REJECTED = "rejected";
    private static final String IN_REVIEW = "inReview";
    private static final String READY_FOR_REVIEW = "readyForReview";
    private static final String DONE = "done";
    private final File rootDir;
    private final String defaultReviewer;

    public FilePersistence(File rootDir, String defaultReviewer) {
        this.rootDir = rootDir;
        this.defaultReviewer = defaultReviewer;
    }

    public Set<String> getFilterNamesForReview() {
        return Collections.singleton("Reviewable");
    }

    public Set<String> getFilterNamesForFixing() {
        return Collections.singleton("Fixable");
    }

    public List<TicketInfo> getTicketsForFilter(String filterName) {
        if (filterName.equals("Reviewable")) {
            return this.getTicketsWithState(READY_FOR_REVIEW, IN_REVIEW);
        }
        if (filterName.equals("Fixable")) {
            return this.getTicketsWithState(REJECTED, IN_IMPLEMENTATION);
        }
        return Collections.emptyList();
    }

    private List<TicketInfo> getTicketsWithState(String ... states) {
        this.checkRoot();
        ArrayList<TicketInfo> ret = new ArrayList<TicketInfo>();
        File[] fileArray = this.rootDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (this.isTicketDir(child) && this.hasAnyOfStates(child, states)) {
                ret.add(this.createTicketInfo(child));
            }
            ++n2;
        }
        return ret;
    }

    private boolean hasAnyOfStates(File child, String[] states) {
        String[] stringArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            String state = stringArray[n2];
            if (this.hasState(child, state)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isTicketDir(File child) {
        return child.isDirectory() && !child.getName().startsWith(".");
    }

    private TicketInfo createTicketInfo(File child) {
        Properties ticketProperties = new Properties();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream stream = new FileInputStream(new File(child, "ticket.properties"));){
                ticketProperties.load(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ReviewtoolException((Exception)e);
        }
        return new TicketInfo(child.getName(), ticketProperties.getProperty("description", ""), this.getState(child), "?", ticketProperties.getProperty("component", ""), ticketProperties.getProperty("parentSummary"), new LinkedHashSet(new TicketDir(child).readReviewHistory()), this.determineWaitingSince(child));
    }

    private Date determineWaitingSince(File child) {
        File stateFile = this.getStateFile(child);
        return stateFile == null ? new Date() : new Date(stateFile.lastModified());
    }

    private boolean hasState(File child, String state) {
        return new File(child, STATE_PREFIX + state).exists();
    }

    private String getState(File child) {
        String[] stringArray = child.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            if (filename.startsWith(STATE_PREFIX)) {
                return filename.substring(STATE_PREFIX.length());
            }
            ++n2;
        }
        return "unknown";
    }

    private File getStateFile(File child) {
        File[] fileArray = child.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().startsWith(STATE_PREFIX)) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    public void saveReviewData(String ticketKey, String newData) {
        try {
            Files.write(this.rootDir.toPath().resolve(ticketKey).resolve(REVIEW_DATA_TXT), newData.getBytes("UTF-8"), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ReviewtoolException((Exception)e);
        }
    }

    public TicketDir loadTicket(String ticketKey) {
        return new TicketDir(this.getTicketDir(ticketKey));
    }

    private File getTicketDir(String ticketKey) {
        return new File(this.rootDir, ticketKey);
    }

    private void checkRoot() {
        if (!this.rootDir.exists()) {
            throw new ReviewtoolException("Das Verzeichnis " + this.rootDir + " existiert nicht.");
        }
        if (!this.rootDir.isDirectory()) {
            throw new ReviewtoolException(this.rootDir + " ist kein Verzeichnis.");
        }
    }

    public void startReviewing(String ticketKey) {
        boolean changeSuccess = this.changeState(ticketKey, READY_FOR_REVIEW, IN_REVIEW);
        if (changeSuccess) {
            this.addUserToReviewHistory(ticketKey, this.defaultReviewer);
        }
    }

    private void addUserToReviewHistory(String ticketKey, String user) {
        TicketDir ticketDir = this.loadTicket(ticketKey);
        ArrayList<String> lines = new ArrayList<String>(ticketDir.readReviewHistory());
        lines.add(user);
        try {
            Files.write(ticketDir.getHistoryFile(), lines, Charset.forName("UTF-8"), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ReviewtoolException((Exception)e);
        }
    }

    public void startFixing(String ticketKey) {
        this.changeState(ticketKey, REJECTED, IN_IMPLEMENTATION);
    }

    private boolean changeState(String ticketKey, String from, String to) {
        File ticketDir = this.getTicketDir(ticketKey);
        return new File(ticketDir, STATE_PREFIX + from).renameTo(new File(ticketDir, STATE_PREFIX + to));
    }

    public void changeStateToReadyForReview(String ticketKey) {
        this.changeState(ticketKey, IN_REVIEW, READY_FOR_REVIEW);
        this.changeState(ticketKey, IN_IMPLEMENTATION, READY_FOR_REVIEW);
    }

    public List<EndTransition> getPossibleTransitionsForReviewEnd(String ticketKey) {
        return Arrays.asList(new EndTransition("OK", DONE, EndTransition.Type.OK), new EndTransition("OK, but needs second review", READY_FOR_REVIEW, EndTransition.Type.OK), new EndTransition("Rejected", REJECTED, EndTransition.Type.REJECTION));
    }

    public void changeStateAtReviewEnd(String ticketKey, EndTransition transition) {
        this.changeState(ticketKey, this.getState(this.getTicketDir(ticketKey)), transition.getInternalName());
    }

    public TicketLinkSettings getLinkSettings() {
        return new TicketLinkSettings("file:///" + this.rootDir.toString().replace('\\', '/') + "/%s", "Open ticket dir");
    }

    private final class TicketDir
    implements ITicketData {
        private final File ticketDir;

        public TicketDir(File file) {
            this.ticketDir = file;
            if (!this.ticketDir.exists()) {
                try {
                    this.createDummyDir();
                }
                catch (IOException e) {
                    throw new ReviewtoolException((Exception)e);
                }
            }
        }

        private void createDummyDir() throws IOException {
            this.ticketDir.mkdir();
            Files.write(this.ticketDir.toPath().resolve("ticket.properties"), ("description=Testticket " + (int)(Math.random() * 1000.0) + "\ncomponent=Main").getBytes(), new OpenOption[0]);
            Files.createFile(this.ticketDir.toPath().resolve("state.readyForReview"), new FileAttribute[0]);
        }

        public String getReviewData() {
            Path reviewDataFile = this.ticketDir.toPath().resolve(FilePersistence.REVIEW_DATA_TXT);
            if (!reviewDataFile.toFile().exists()) {
                return "";
            }
            try {
                return new String(Files.readAllBytes(reviewDataFile), "UTF-8");
            }
            catch (IOException e) {
                throw new ReviewtoolException((Exception)e);
            }
        }

        public String getReviewerForRound(int number) {
            List<String> lines = this.readReviewHistory();
            if (number > lines.size() || number <= 0) {
                return FilePersistence.this.defaultReviewer;
            }
            return lines.get(number - 1);
        }

        public Date getEndTimeForRound(int number) {
            return new Date();
        }

        public int getCurrentRound() {
            return this.readReviewHistory().size();
        }

        private List<String> readReviewHistory() {
            Path historyFile = this.getHistoryFile();
            if (!historyFile.toFile().exists()) {
                return Collections.emptyList();
            }
            try {
                return Files.readAllLines(historyFile, Charset.forName("UTF-8"));
            }
            catch (IOException e) {
                throw new ReviewtoolException((Exception)e);
            }
        }

        private Path getHistoryFile() {
            return this.ticketDir.toPath().resolve(FilePersistence.REVIEW_HISTORY_TXT);
        }

        public TicketInfo getTicketInfo() {
            return FilePersistence.this.createTicketInfo(this.ticketDir);
        }

        public String getId() {
            return this.ticketDir.getName();
        }
    }
}

