/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.changesources.git;

import de.setsoftware.reviewtool.base.IPartiallyComparable;
import de.setsoftware.reviewtool.changesources.git.GitRevision;
import de.setsoftware.reviewtool.changesources.git.GitWorkingCopy;
import de.setsoftware.reviewtool.changesources.git.RevisionId;
import de.setsoftware.reviewtool.diffalgorithms.DiffAlgorithmFactory;
import de.setsoftware.reviewtool.model.api.IChangeSourceUi;
import de.setsoftware.reviewtool.model.api.IFileHistoryGraph;
import de.setsoftware.reviewtool.model.api.ILocalRevision;
import de.setsoftware.reviewtool.model.api.IRepoRevision;
import de.setsoftware.reviewtool.model.api.IRepository;
import de.setsoftware.reviewtool.model.api.IRevision;
import de.setsoftware.reviewtool.model.api.IWorkingCopy;
import de.setsoftware.reviewtool.model.changestructure.ChangestructureFactory;
import de.setsoftware.reviewtool.model.changestructure.FileHistoryGraph;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

final class GitWorkingCopyManager {
    private static final GitWorkingCopyManager INSTANCE = new GitWorkingCopyManager();
    private final Map<String, GitWorkingCopy> wcPerRootDirectory = new LinkedHashMap<String, GitWorkingCopy>();

    private GitWorkingCopyManager() {
    }

    static GitWorkingCopyManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset() {
        GitWorkingCopyManager gitWorkingCopyManager = INSTANCE;
        synchronized (gitWorkingCopyManager) {
            GitWorkingCopyManager.INSTANCE.wcPerRootDirectory.clear();
        }
    }

    synchronized Collection<GitWorkingCopy> getWorkingCopies() {
        return new ArrayList<GitWorkingCopy>(this.wcPerRootDirectory.values());
    }

    synchronized GitWorkingCopy getWorkingCopy(File workingCopyRoot, File cacheDir) {
        GitWorkingCopy wc = this.wcPerRootDirectory.get(workingCopyRoot.toString());
        if (wc == null) {
            wc = new GitWorkingCopy(workingCopyRoot, cacheDir);
            this.wcPerRootDirectory.put(workingCopyRoot.toString(), wc);
        }
        return wc;
    }

    synchronized void removeWorkingCopy(File workingCopyRoot) {
        this.wcPerRootDirectory.remove(workingCopyRoot.toString());
    }

    Map<GitRevision, String> traverseEntries(Predicate<GitRevision> handler, IChangeSourceUi ui) throws GitAPIException, IOException {
        LinkedHashMap<GitRevision, String> ret = new LinkedHashMap<GitRevision, String>();
        block6: for (GitWorkingCopy wc : this.getWorkingCopies()) {
            Repository repository = wc.getRepository().getRepository();
            ArrayList allRefs = new ArrayList(repository.getRefDatabase().getRefs());
            Collections.sort(allRefs, (r1, r2) -> {
                String n1 = r1.getName();
                String n2 = r2.getName();
                if (n1.equals("HEAD")) {
                    return n2.equals("HEAD") ? 0 : -1;
                }
                if (n2.equals("HEAD")) {
                    return 1;
                }
                return n1.compareTo(n2);
            });
            HashSet<ObjectId> visited = new HashSet<ObjectId>();
            block7: for (Ref ref : allRefs) {
                Throwable throwable = null;
                Object var12_13 = null;
                try (RevWalk revWalk = new RevWalk(repository);){
                    if (visited.contains(ref.getObjectId())) continue block6;
                    revWalk.markStart(revWalk.parseCommit((AnyObjectId)ref.getObjectId()));
                    for (RevCommit commit : revWalk) {
                        if (visited.contains(commit.getId())) {
                            continue block7;
                        }
                        visited.add(commit.getId());
                        GitRevision r = new GitRevision(wc, commit);
                        if (!handler.test(r)) continue;
                        ret.put(r, ref.getName());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        return ret;
    }

    void collectWorkingCopyChanges(List<File> relevantPaths) throws IOException, GitAPIException {
        for (GitWorkingCopy wc : this.getWorkingCopies()) {
            this.collectWorkingCopyChanges(wc, relevantPaths);
        }
    }

    private void collectWorkingCopyChanges(GitWorkingCopy wc, List<? extends File> relevantPaths) throws IOException, GitAPIException {
        Repository repo = wc.getRepository().getRepository();
        ObjectId head = repo.resolve("HEAD");
        if (head == null) {
            return;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (Git git = new Git(repo);){
            RevCommit headCommit;
            StatusCommand status = git.status();
            if (relevantPaths != null) {
                for (File file : relevantPaths) {
                    status.addPath(file.toString());
                }
            }
            Status status2 = status.call();
            ILocalRevision wcRevision = ChangestructureFactory.createLocalRevision((IWorkingCopy)wc);
            Throwable throwable2 = null;
            Object throwable3 = null;
            try (RevWalk revWalk = new RevWalk(repo);){
                headCommit = revWalk.parseCommit((AnyObjectId)head);
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
            IRepoRevision headRevision = ChangestructureFactory.createRepoRevision((IPartiallyComparable)new RevisionId(headCommit), (IRepository)wc.getRepository());
            FileHistoryGraph localFileHistoryGraph = new FileHistoryGraph(DiffAlgorithmFactory.createDefault());
            for (String modifiedFile : status2.getModified()) {
                localFileHistoryGraph.addChange(modifiedFile, (IRevision)wcRevision, Collections.singleton(headRevision));
            }
            wc.setLocalFileHistoryGraph((IFileHistoryGraph)localFileHistoryGraph);
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

