/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.changesources.git;

import de.setsoftware.reviewtool.changesources.git.GitRepository;
import de.setsoftware.reviewtool.diffalgorithms.DiffAlgorithmFactory;
import de.setsoftware.reviewtool.model.api.IFileHistoryGraph;
import de.setsoftware.reviewtool.model.changestructure.AbstractWorkingCopy;
import de.setsoftware.reviewtool.model.changestructure.FileHistoryGraph;
import de.setsoftware.reviewtool.model.changestructure.VirtualFileHistoryGraph;
import java.io.File;
import java.nio.file.Path;

final class GitWorkingCopy
extends AbstractWorkingCopy {
    private final GitRepository repository;
    private final File workingCopyRoot;
    private VirtualFileHistoryGraph combinedFileHistoryGraph;

    GitWorkingCopy(File workingCopyRoot, File cacheDir) {
        this.workingCopyRoot = workingCopyRoot;
        this.repository = GitRepository.create(workingCopyRoot, cacheDir);
        this.combinedFileHistoryGraph = new VirtualFileHistoryGraph((IFileHistoryGraph)this.repository.getFileHistoryGraph());
        this.setLocalFileHistoryGraph((IFileHistoryGraph)new FileHistoryGraph(DiffAlgorithmFactory.createDefault()));
    }

    public GitRepository getRepository() {
        return this.repository;
    }

    public File getLocalRoot() {
        return this.workingCopyRoot;
    }

    public File toAbsolutePathInWc(String absolutePathInRepo) {
        return new File(this.workingCopyRoot, absolutePathInRepo);
    }

    public String toAbsolutePathInRepo(File absolutePathInWc) {
        Path wcRootPath = this.workingCopyRoot.toPath();
        Path wcPath = absolutePathInWc.toPath();
        if (wcPath.startsWith(wcRootPath)) {
            try {
                String relativePath = wcRootPath.relativize(wcPath).toString().replaceAll("\\\\", "/");
                return String.valueOf('/') + relativePath;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    public IFileHistoryGraph getFileHistoryGraph() {
        return this.combinedFileHistoryGraph;
    }

    void setLocalFileHistoryGraph(IFileHistoryGraph localFileHistoryGraph) {
        this.combinedFileHistoryGraph.setLocalFileHistoryGraph(localFileHistoryGraph);
    }

    void clearCache() {
        this.repository.clearCache();
        VirtualFileHistoryGraph oldGraph = this.combinedFileHistoryGraph;
        this.combinedFileHistoryGraph = new VirtualFileHistoryGraph((IFileHistoryGraph)this.repository.getFileHistoryGraph());
        this.setLocalFileHistoryGraph(oldGraph.getLocalFileHistoryGraph());
    }
}

