/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.changesources.git;

import de.setsoftware.reviewtool.base.Logger;
import de.setsoftware.reviewtool.changesources.git.GitRevision;
import de.setsoftware.reviewtool.changesources.git.GitWorkingCopy;
import de.setsoftware.reviewtool.changesources.git.GitWorkingCopyManager;
import de.setsoftware.reviewtool.changesources.git.HistoryFiller;
import de.setsoftware.reviewtool.model.api.BackgroundJobExecutor;
import de.setsoftware.reviewtool.model.api.ChangeSourceException;
import de.setsoftware.reviewtool.model.api.IChange;
import de.setsoftware.reviewtool.model.api.IChangeData;
import de.setsoftware.reviewtool.model.api.IChangeSource;
import de.setsoftware.reviewtool.model.api.IChangeSourceUi;
import de.setsoftware.reviewtool.model.api.ICommit;
import de.setsoftware.reviewtool.model.api.ICortProgressMonitor;
import de.setsoftware.reviewtool.model.api.IFileHistoryNode;
import de.setsoftware.reviewtool.model.api.IRevision;
import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import de.setsoftware.reviewtool.model.api.IWorkingCopy;
import de.setsoftware.reviewtool.model.changestructure.AbstractChangeSource;
import de.setsoftware.reviewtool.model.changestructure.ChangestructureFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.eclipse.jgit.api.errors.GitAPIException;

public class GitChangeSource
extends AbstractChangeSource {
    private File cacheDir;

    GitChangeSource(String logMessagePattern, long maxTextDiffThreshold, File cacheDir) {
        super(logMessagePattern, maxTextDiffThreshold);
        this.cacheDir = cacheDir;
    }

    public IChangeData getRepositoryChanges(String key, IChangeSourceUi ui) throws ChangeSourceException {
        try {
            ui.subTask("Determining relevant commits...");
            Map<GitRevision, String> revisions = this.determineRelevantRevisions(key, ui);
            List<GitRevision> selectedRevisions = this.checkBranches(revisions, ui);
            ui.subTask("Analyzing commits...");
            List<ICommit> commits = this.convertRepoRevisionsToChanges(selectedRevisions, (ICortProgressMonitor)ui);
            return ChangestructureFactory.createChangeData(commits);
        }
        catch (IOException | GitAPIException e) {
            throw new ChangeSourceException((IChangeSource)this, e);
        }
    }

    private List<GitRevision> checkBranches(Map<GitRevision, String> revisions, IChangeSourceUi ui) {
        ArrayList<GitRevision> ret = new ArrayList<GitRevision>();
        ArrayList<GitRevision> nonHeadRevisions = new ArrayList<GitRevision>();
        LinkedHashSet<String> refs = new LinkedHashSet<String>();
        for (Map.Entry<GitRevision, String> e : revisions.entrySet()) {
            if (e.getValue().equals("HEAD")) {
                ret.add(e.getKey());
                continue;
            }
            nonHeadRevisions.add(e.getKey());
            refs.add(e.getValue());
        }
        if (!nonHeadRevisions.isEmpty()) {
            Boolean answer = ui.handleLocalWorkingIncomplete("The current HEAD does not contain all commits for the ticket (other refs: " + refs + "). Restrict review to current HEAD?");
            if (answer == null) {
                throw BackgroundJobExecutor.createOperationCanceledException();
            }
            if (!answer.booleanValue()) {
                ret.addAll(nonHeadRevisions);
            }
        }
        return ret;
    }

    private Map<GitRevision, String> determineRelevantRevisions(String key, IChangeSourceUi ui) throws GitAPIException, IOException {
        Pattern pattern = this.createPatternForKey(key);
        HistoryFiller historyFiller = new HistoryFiller();
        Predicate<GitRevision> handler = logEntry -> {
            historyFiller.register((GitRevision)logEntry);
            String message = logEntry.getMessage();
            return message != null && pattern.matcher(message).matches();
        };
        Map<GitRevision, String> matchingEntries = GitWorkingCopyManager.getInstance().traverseEntries(handler, ui);
        historyFiller.populate(matchingEntries.keySet(), ui);
        return matchingEntries;
    }

    private List<ICommit> convertRepoRevisionsToChanges(List<GitRevision> revisions, ICortProgressMonitor ui) throws IOException {
        ArrayList<ICommit> ret = new ArrayList<ICommit>();
        for (GitRevision e : revisions) {
            if (ui.isCanceled()) {
                throw BackgroundJobExecutor.createOperationCanceledException();
            }
            this.convertToCommitIfPossible(e, ret, ui);
        }
        return ret;
    }

    private void convertToCommitIfPossible(GitRevision e, Collection<? super ICommit> result, ICortProgressMonitor ui) throws IOException {
        List<? extends IChange> changes = this.determineChangesInCommit(e, ui);
        if (!changes.isEmpty()) {
            result.add((ICommit)ChangestructureFactory.createCommit((IWorkingCopy)e.getWorkingCopy(), (String)e.toPrettyString(), changes, (IRevision)e.toRevision(), (Date)e.getDate()));
        }
    }

    private List<? extends IChange> determineChangesInCommit(GitRevision e, ICortProgressMonitor ui) throws IOException {
        ArrayList ret = new ArrayList();
        Set<String> changedPaths = e.getChangedPaths();
        ArrayList<String> sortedPaths = new ArrayList<String>(changedPaths);
        Collections.sort(sortedPaths);
        for (String path : sortedPaths) {
            if (ui.isCanceled()) {
                throw BackgroundJobExecutor.createOperationCanceledException();
            }
            IRevisionedFile fileInfo = ChangestructureFactory.createFileInRevision((String)path, (IRevision)e.toRevision());
            IFileHistoryNode node = e.getWorkingCopy().getFileHistoryGraph().getNodeFor(fileInfo);
            if (node != null) {
                try {
                    ret.addAll(this.determineChangesInFile((IWorkingCopy)e.getWorkingCopy(), node));
                }
                catch (Exception ex) {
                    Logger.error((String)("An error occurred while computing changes for " + fileInfo.toString()), (Throwable)ex);
                }
                continue;
            }
            Logger.debug((String)("history node is null for " + fileInfo));
        }
        return ret;
    }

    public void analyzeLocalChanges(List<File> relevantPaths) throws ChangeSourceException {
        try {
            GitWorkingCopyManager.getInstance().collectWorkingCopyChanges(relevantPaths);
        }
        catch (IOException | GitAPIException e) {
            throw new ChangeSourceException((IChangeSource)this, e);
        }
    }

    public File determineWorkingCopyRoot(File projectRoot) throws ChangeSourceException {
        File dir = projectRoot;
        do {
            if (!this.containsDotGit(dir)) continue;
            return dir;
        } while ((dir = dir.getParentFile()) != null);
        return null;
    }

    private boolean containsDotGit(File dir) {
        File dotGit = new File(dir, ".git");
        return dotGit.isDirectory();
    }

    protected void workingCopyAdded(File wcRoot) {
        GitWorkingCopyManager.getInstance().getWorkingCopy(wcRoot, this.cacheDir);
    }

    protected void workingCopyRemoved(File wcRoot) {
        GitWorkingCopyManager.getInstance().removeWorkingCopy(wcRoot);
    }

    public void clearCaches() {
        for (GitWorkingCopy wc : GitWorkingCopyManager.getInstance().getWorkingCopies()) {
            wc.clearCache();
        }
    }
}

