/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.tourrestructuring.onestop;

import de.setsoftware.reviewtool.base.Util;
import de.setsoftware.reviewtool.model.api.IStop;
import de.setsoftware.reviewtool.model.changestructure.Stop;
import de.setsoftware.reviewtool.model.changestructure.Tour;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

class MutableTour {
    private final Set<String> descriptionParts = new LinkedHashSet<String>();
    private final List<Stop> stops;

    public MutableTour(Tour t) {
        this.descriptionParts.add(t.getDescription());
        this.stops = new ArrayList<Stop>(t.getStops());
    }

    public static List<Tour> toTours(List<MutableTour> mutableTours) {
        ArrayList<Tour> ret = new ArrayList<Tour>();
        for (MutableTour t : mutableTours) {
            ret.add(new Tour(Util.implode(t.descriptionParts, (String)" + "), t.stops));
        }
        return ret;
    }

    public boolean canBeResolvedCompletely(List<MutableTour> mutableTours, int excludedIndex) {
        for (Stop s : this.stops) {
            if (this.canBeMerged(s, mutableTours, excludedIndex)) continue;
            return false;
        }
        return true;
    }

    private boolean canBeMerged(Stop s, List<MutableTour> mutableTours, int excludedIndex) {
        StopInTour toMergeWith = this.getStopToMergeWith(s, mutableTours, excludedIndex);
        return toMergeWith != null && !mutableTours.get(excludedIndex).equals(toMergeWith.tour);
    }

    public boolean resolve(List<MutableTour> mutableTours, int currentIndex) {
        boolean didSomething = false;
        Iterator<Stop> iter = this.stops.iterator();
        while (iter.hasNext()) {
            Stop s = iter.next();
            StopInTour toMergeWith = this.getStopToMergeWith(s, mutableTours, currentIndex);
            if (toMergeWith == null) continue;
            toMergeWith.merge(s);
            ((StopInTour)toMergeWith).tour.descriptionParts.addAll(this.descriptionParts);
            iter.remove();
            didSomething = true;
        }
        return didSomething;
    }

    private StopInTour getStopToMergeWith(Stop s, List<MutableTour> mutableTours, int currentIndex) {
        StopInTour mergeWith;
        int tourIndex = currentIndex + 1;
        while (tourIndex < mutableTours.size()) {
            mergeWith = mutableTours.get(tourIndex).getStopToMergeWith(s);
            if (mergeWith != null) {
                return mergeWith;
            }
            ++tourIndex;
        }
        StopInTour mergeWith2 = mutableTours.get(currentIndex).getStopToMergeWith(s);
        if (mergeWith2 != null) {
            return mergeWith2;
        }
        tourIndex = currentIndex - 1;
        while (tourIndex >= 0) {
            mergeWith = mutableTours.get(tourIndex).getStopToMergeWith(s);
            if (mergeWith != null) {
                return mergeWith;
            }
            --tourIndex;
        }
        return null;
    }

    private StopInTour getStopToMergeWith(Stop s) {
        int stopIndex = 0;
        while (stopIndex < this.stops.size()) {
            Stop stop = this.stops.get(stopIndex);
            if (!s.equals((Object)stop) && stop.canBeMergedWith((IStop)s)) {
                return new StopInTour(this, stopIndex);
            }
            ++stopIndex;
        }
        return null;
    }

    private void mergeStop(int index, Stop s) {
        this.stops.set(index, this.stops.get(index).merge(s));
    }

    public boolean isEmpty() {
        return this.stops.isEmpty();
    }

    private static class StopInTour {
        private final MutableTour tour;
        private final int index;

        public StopInTour(MutableTour tour, int stopIndex) {
            this.tour = tour;
            this.index = stopIndex;
        }

        public void merge(Stop s) {
            this.tour.mergeStop(this.index, s);
        }
    }
}

