/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.ordering;

import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import de.setsoftware.reviewtool.ordering.ChangePart;
import de.setsoftware.reviewtool.ordering.HierarchyExplicitness;
import de.setsoftware.reviewtool.ordering.OrderingInfo;
import de.setsoftware.reviewtool.ordering.OrderingInfoImpl;
import de.setsoftware.reviewtool.ordering.RelationMatcher;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.TourCalculatorControl;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public class XsdBeforeRestRelation
implements RelationMatcher {
    private final HierarchyExplicitness explicitness;

    public XsdBeforeRestRelation(HierarchyExplicitness explicitness) {
        this.explicitness = explicitness;
    }

    @Override
    public Collection<? extends OrderingInfo> determineMatches(List<ChangePart> changeParts, TourCalculatorControl control) {
        LinkedHashSet<ChangePart> xsd = new LinkedHashSet<ChangePart>();
        LinkedHashSet<ChangePart> other = new LinkedHashSet<ChangePart>();
        for (ChangePart c : changeParts) {
            if (c.isFullyIrrelevantForReview()) continue;
            IRevisionedFile file = c.getStops().get(0).getMostRecentFile();
            if (file.getPath().endsWith(".xsd")) {
                xsd.add(c);
                continue;
            }
            other.add(c);
        }
        if (xsd.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.singleton(OrderingInfoImpl.bigStar(this.explicitness, "xsd before rest", xsd, other));
    }
}

