/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.changesources.svn;

import de.setsoftware.reviewtool.changesources.svn.ISvnRepo;
import java.io.File;
import java.io.Serializable;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

final class CachedLogEntryPath
implements Serializable {
    private static final long serialVersionUID = -7052753449952234943L;
    private final String path;
    private final File localPath;
    private final long prevRevision;
    private final String copyPath;
    private final long copyRevision;
    private final char type;
    private final char kind;

    CachedLogEntryPath(SVNLogEntryPath value, long prevRevision) {
        this.path = value.getPath();
        this.localPath = null;
        this.copyPath = value.getCopyPath();
        this.prevRevision = prevRevision;
        this.copyRevision = value.getCopyRevision();
        this.type = value.getType();
        this.kind = CachedLogEntryPath.mapStatusKind(value.getKind());
    }

    CachedLogEntryPath(ISvnRepo repo, SVNStatus status) {
        this.prevRevision = status.getRevision().equals((Object)SVNRevision.UNDEFINED) ? SVNRevision.BASE.getNumber() : status.getRevision().getNumber();
        String copySourceUrl = status.getCopyFromURL();
        if (copySourceUrl != null) {
            this.path = String.valueOf('/') + status.getRepositoryRelativePath();
            this.copyPath = copySourceUrl.substring(repo.getRemoteUrl().toString().length());
            this.copyRevision = status.getCopyFromRevision().getNumber();
        } else {
            this.path = String.valueOf('/') + status.getRepositoryRelativePath();
            this.copyPath = null;
            this.copyRevision = -1L;
        }
        this.localPath = status.getFile();
        this.type = CachedLogEntryPath.mapStatusTypeToLogEntryType(status.getNodeStatus());
        this.kind = CachedLogEntryPath.mapStatusKind(status.getKind());
    }

    private static char mapStatusKind(SVNNodeKind nodeKind) {
        if (nodeKind.equals(SVNNodeKind.FILE)) {
            return 'F';
        }
        if (nodeKind.equals(SVNNodeKind.DIR)) {
            return 'D';
        }
        return ' ';
    }

    private static char mapStatusTypeToLogEntryType(SVNStatusType type) {
        if (type == SVNStatusType.STATUS_ADDED) {
            return 'A';
        }
        if (type == SVNStatusType.STATUS_DELETED) {
            return 'D';
        }
        if (type == SVNStatusType.STATUS_MODIFIED) {
            return 'M';
        }
        if (type == SVNStatusType.STATUS_REPLACED) {
            return 'R';
        }
        return ' ';
    }

    String getPath() {
        return this.path;
    }

    File getLocalPath() {
        return this.localPath;
    }

    long getAncestorRevision() {
        return this.prevRevision;
    }

    String getCopyPath() {
        return this.copyPath;
    }

    long getCopyRevision() {
        return this.copyRevision;
    }

    boolean isFile() {
        return this.kind == 'F';
    }

    boolean isDir() {
        return this.kind == 'D';
    }

    boolean isNew() {
        return this.type == 'A';
    }

    boolean isDeleted() {
        return this.type == 'D';
    }

    boolean isReplaced() {
        return this.type == 'R';
    }
}

