/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.remarks;

import de.setsoftware.reviewtool.model.remarks.IMarkerFactory;
import de.setsoftware.reviewtool.model.remarks.ReviewDataParser;
import de.setsoftware.reviewtool.model.remarks.ReviewRemark;
import de.setsoftware.reviewtool.model.remarks.ReviewRemarkException;
import de.setsoftware.reviewtool.model.remarks.ReviewRound;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ReviewData {
    private final List<ReviewRound> rounds = new ArrayList<ReviewRound>();

    public ReviewData() {
    }

    ReviewData(List<ReviewRound> sortedRounds) {
        this.rounds.addAll(sortedRounds);
    }

    public static ReviewData parse(Map<Integer, String> reviewersForRounds, IMarkerFactory m, String oldReviewData) {
        try {
            String line;
            BufferedReader r = new BufferedReader(new StringReader(oldReviewData));
            ReviewDataParser parser = new ReviewDataParser(reviewersForRounds, m);
            while ((line = r.readLine()) != null) {
                String trimmedLine = line.trim();
                parser.handleNextLine(trimmedLine);
            }
            parser.endLastItem();
            return parser.getResult();
        }
        catch (IOException e) {
            throw new ReviewRemarkException(e);
        }
    }

    public void merge(ReviewRemark reviewRemark, int defaultRoundNumber) throws ReviewRemarkException {
        ReviewRound round = this.findRoundWith(reviewRemark);
        if (round == null) {
            round = this.getOrCreateRound(defaultRoundNumber);
        }
        round.merge(reviewRemark);
    }

    private ReviewRound findRoundWith(ReviewRemark reviewRemark) {
        ListIterator<ReviewRound> iter = this.rounds.listIterator(this.rounds.size());
        while (iter.hasPrevious()) {
            ReviewRound round = iter.previous();
            if (!round.contains(reviewRemark)) continue;
            return round;
        }
        return null;
    }

    private ReviewRound getOrCreateRound(int roundNumber) {
        int roundIndex = Math.max(roundNumber - 1, 0);
        while (roundIndex >= this.rounds.size()) {
            this.rounds.add(new ReviewRound(this.rounds.size() + 1));
        }
        return this.rounds.get(roundIndex);
    }

    public String serialize() throws ReviewRemarkException {
        ListIterator<ReviewRound> iter = this.rounds.listIterator(this.rounds.size());
        StringBuilder ret = new StringBuilder();
        while (iter.hasPrevious()) {
            ReviewRound round = iter.previous();
            if (round.isEmpty()) continue;
            if (ret.length() > 0) {
                ret.append("\n");
            }
            ret.append(round.serialize());
        }
        return ret.toString();
    }

    public boolean hasUnresolvedRemarks() throws ReviewRemarkException {
        for (ReviewRound r : this.rounds) {
            if (!r.hasUnresolvedRemarks()) continue;
            return true;
        }
        return false;
    }

    public boolean hasTemporaryMarkers() throws ReviewRemarkException {
        for (ReviewRound r : this.rounds) {
            if (!r.hasTemporaryMarkers()) continue;
            return true;
        }
        return false;
    }

    public void deleteRemark(ReviewRemark reviewRemark) throws ReviewRemarkException {
        for (ReviewRound r : this.rounds) {
            r.deleteRemark(reviewRemark);
        }
    }

    public List<ReviewRound> getReviewRounds() {
        return this.rounds;
    }
}

