/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.ordering.efficientalgorithm;

import de.setsoftware.reviewtool.ordering.efficientalgorithm.BundleCombination;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.BundleCombinationTreeElement;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.MatchSet;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.SimpleSet;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.SimpleSetAdapter;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.StarMatchSet;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.SubsettingSet;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.TourCalculatorControl;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.UnorderedMatchSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TourCalculator<T> {
    private final Set<MatchSet<T>> successfulMatches = new LinkedHashSet<MatchSet<T>>();
    private List<T> resultingTour;

    private static <S> boolean disjoint(Set<S> c1, Set<S> c2) {
        Set<S> contains;
        Set<S> iterate;
        if (c1.size() > c2.size()) {
            iterate = c2;
            contains = c1;
        } else {
            iterate = c1;
            contains = c2;
        }
        for (S e : iterate) {
            if (!contains.contains(e)) continue;
            return false;
        }
        return true;
    }

    public static <S> TourCalculator<S> calculateFor(List<S> allChangeParts, List<MatchSet<S>> matchSets, Comparator<S> tieBreakingComparator, TourCalculatorControl isCanceled) throws InterruptedException {
        BundleCombinationTreeElement<Object> next;
        assert (new HashSet<S>(allChangeParts).size() == allChangeParts.size()) : "there are duplicate change parts";
        TourCalculator ret = new TourCalculator();
        if (allChangeParts.size() <= 1) {
            ret.resultingTour = new ArrayList<S>(allChangeParts);
            return ret;
        }
        BundleCombination<Object> bundler = BundleCombinationTreeElement.create(allChangeParts);
        ArrayList unsatisfiedMatches = new ArrayList();
        for (MatchSet<S> matchSet : matchSets) {
            BundleCombination next2 = ((BundleCombinationTreeElement)bundler).bundle((SimpleSet)new SimpleSetAdapter<S>(matchSet.getChangeParts()));
            if (next2 != null) {
                bundler = next2;
                ret.successfulMatches.add(matchSet);
            } else {
                unsatisfiedMatches.add(matchSet);
            }
            TourCalculator.checkInterruption(isCanceled);
        }
        if (isCanceled.isFastModeNeeded()) {
            ret.resultingTour = bundler.getPossibleOrder(tieBreakingComparator);
            return ret;
        }
        FoldMatchingHelper foldedBundler = new FoldMatchingHelper(bundler, unsatisfiedMatches);
        foldedBundler.addPotentialFolds(ret.successfulMatches, isCanceled);
        bundler = foldedBundler.getBundler();
        for (MatchSet<Object> matchSet : ret.successfulMatches) {
            if (!(matchSet instanceof StarMatchSet)) continue;
            HashSet rest = new HashSet(matchSet.getChangeParts());
            Set distinguishedPart = ((StarMatchSet)matchSet).getDistinguishedPart();
            rest.removeAll(distinguishedPart);
            next = ((BundleCombinationTreeElement)bundler).bundleOrdered(new SimpleSetAdapter(distinguishedPart), new SimpleSetAdapter(rest));
            if (next != null) {
                bundler = next;
            }
            TourCalculator.checkInterruption(isCanceled);
        }
        for (MatchSet<Object> matchSet : foldedBundler.matchedWithFolds.keySet()) {
            if (!(matchSet instanceof StarMatchSet)) continue;
            HashSet center = new HashSet();
            center.addAll(((StarMatchSet)matchSet).getDistinguishedPart());
            HashSet<Object> rest = new HashSet<Object>(matchSet.getChangeParts());
            for (MatchSet neededFold : (List)foldedBundler.matchedWithFolds.get(matchSet)) {
                if (TourCalculator.disjoint(neededFold.getChangeParts(), center)) {
                    rest.addAll(neededFold.getChangeParts());
                    continue;
                }
                center.addAll(neededFold.getChangeParts());
            }
            rest.removeAll(center);
            if (rest.isEmpty()) continue;
            next = ((BundleCombinationTreeElement)bundler).bundleOrdered(new SimpleSetAdapter(center), new SimpleSetAdapter<Object>(rest));
            if (next != null) {
                bundler = next;
            }
            TourCalculator.checkInterruption(isCanceled);
        }
        ret.resultingTour = bundler.getPossibleOrder(tieBreakingComparator);
        return ret;
    }

    public List<T> getTour() {
        return this.resultingTour;
    }

    public static void checkInterruption(TourCalculatorControl isCanceled) throws InterruptedException {
        if (Thread.interrupted() || isCanceled.isCanceled()) {
            throw new InterruptedException();
        }
    }

    private static final class FoldMatchingHelper<S> {
        private BundleCombinationTreeElement<S> bundler;
        private final Map<MatchSet<S>, List<MatchSet<S>>> unsatisfiedMatchesWithPotentiallyRelevantFolds;
        private final LinkedList<MatchSet<S>> todoQueue;
        private final Map<MatchSet<S>, List<MatchSet<S>>> matchedWithFolds;

        public FoldMatchingHelper(BundleCombinationTreeElement<S> bundler, List<MatchSet<S>> unsatisfiedMatches) {
            this.bundler = bundler;
            this.unsatisfiedMatchesWithPotentiallyRelevantFolds = new LinkedHashMap<MatchSet<S>, List<MatchSet<S>>>();
            for (MatchSet<S> unsatisfiedMatch : unsatisfiedMatches) {
                this.unsatisfiedMatchesWithPotentiallyRelevantFolds.put(unsatisfiedMatch, new ArrayList());
            }
            this.todoQueue = new LinkedList();
            this.matchedWithFolds = new LinkedHashMap<MatchSet<S>, List<MatchSet<S>>>();
        }

        public void addPotentialFolds(Collection<MatchSet<S>> matches, TourCalculatorControl control) throws InterruptedException {
            this.todoQueue.addAll(matches);
            while (!this.todoQueue.isEmpty()) {
                LinkedHashSet<MatchSet<S>> unsatisfiedMatchesThatCouldNowMatch = new LinkedHashSet<MatchSet<S>>();
                while (!this.todoQueue.isEmpty()) {
                    MatchSet<S> matchSet = this.todoQueue.poll();
                    for (Map.Entry<MatchSet<S>, List<MatchSet<S>>> e : this.unsatisfiedMatchesWithPotentiallyRelevantFolds.entrySet()) {
                        if (TourCalculator.disjoint(e.getKey().getChangeParts(), matchSet.getChangeParts())) continue;
                        this.removeSubsets(e.getValue(), matchSet);
                        e.getValue().add(matchSet);
                        unsatisfiedMatchesThatCouldNowMatch.add(e.getKey());
                    }
                }
                TourCalculator.checkInterruption(control);
                for (MatchSet matchSet : unsatisfiedMatchesThatCouldNowMatch) {
                    this.matchWithNewFold(matchSet, this.unsatisfiedMatchesWithPotentiallyRelevantFolds.get(matchSet), control);
                }
            }
        }

        private void removeSubsets(List<MatchSet<S>> value, MatchSet<S> toFold) {
            Iterator<MatchSet<S>> iter = value.iterator();
            while (iter.hasNext()) {
                MatchSet<S> cur = iter.next();
                if (!toFold.getChangeParts().containsAll(cur.getChangeParts())) continue;
                iter.remove();
            }
        }

        private void matchWithNewFold(MatchSet<S> toMatch, List<MatchSet<S>> potentialFolds, TourCalculatorControl control) {
            SubsettingSet<S> activeFolds = new SubsettingSet<S>(toMatch, potentialFolds);
            boolean matchesWithFullSet = this.matchesWithFoldSubset(toMatch, activeFolds);
            if (!matchesWithFullSet) {
                return;
            }
            if (!control.isFastModeNeeded()) {
                for (Integer index : activeFolds.potentialRemovals()) {
                    activeFolds.preliminaryRemove(index);
                    if (this.matchesWithFoldSubset(toMatch, activeFolds)) {
                        activeFolds.commitRemoval();
                        continue;
                    }
                    activeFolds.rollbackRemoval();
                }
            }
            this.bundler = this.bundler.bundle((SimpleSet)activeFolds);
            this.todoQueue.add(new UnorderedMatchSet<S>(activeFolds.toSet()));
            this.matchedWithFolds.put(toMatch, this.selectActiveFolds(potentialFolds, activeFolds));
            this.unsatisfiedMatchesWithPotentiallyRelevantFolds.remove(toMatch);
        }

        private boolean matchesWithFoldSubset(MatchSet<S> toMatch, SimpleSet<S> set) {
            return this.bundler.bundle((SimpleSet)set) != null;
        }

        private List<MatchSet<S>> selectActiveFolds(List<MatchSet<S>> potentialFolds, SubsettingSet<S> activeFolds) {
            ArrayList<MatchSet<S>> ret = new ArrayList<MatchSet<S>>();
            for (Integer index : activeFolds.potentialRemovals()) {
                ret.add(potentialFolds.get(index));
            }
            return ret;
        }

        public BundleCombinationTreeElement<S> getBundler() {
            return this.bundler;
        }
    }
}

