/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.ordering.efficientalgorithm;

import de.setsoftware.reviewtool.ordering.efficientalgorithm.BundleCombinationTreeElement;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.SimpleSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class BundleCombinationTreeLeaf<T>
extends BundleCombinationTreeElement<T> {
    private final T value;
    private final BundleCombinationTreeElement.BundleResult<T> thisFull;
    private final BundleCombinationTreeElement.BundleResult<T> thisNone;

    BundleCombinationTreeLeaf(T value) {
        this.value = value;
        this.thisFull = new BundleCombinationTreeElement.BundleResult(BundleCombinationTreeElement.ResultType.FULL, this);
        this.thisNone = new BundleCombinationTreeElement.BundleResult(BundleCombinationTreeElement.ResultType.NONE, this);
    }

    @Override
    protected BundleCombinationTreeElement.BundleResult<T> addBundle(SimpleSet<T> bundle) {
        return bundle.contains(this.value) ? this.thisFull : this.thisNone;
    }

    @Override
    public List<T> getPossibleOrder(Comparator<T> tieBreakingComparator) {
        return Collections.singletonList(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    protected List<? extends BundleCombinationTreeElement<T>> split(SimpleSet<T> bundle) {
        return Collections.singletonList(this);
    }

    @Override
    protected BundleCombinationTreeElement.ResultType checkContainment(SimpleSet<T> bundle) {
        return bundle.contains(this.value) ? BundleCombinationTreeElement.ResultType.FULL : BundleCombinationTreeElement.ResultType.NONE;
    }

    @Override
    protected BundleCombinationTreeElement<T> reverse() {
        return this;
    }

    @Override
    protected BundleCombinationTreeElement<T> fixOrder(SimpleSet<T> center, SimpleSet<T> rest) {
        return this;
    }
}

