/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.ticketconnectors.jira;

import de.setsoftware.reviewtool.config.IConfigurator;
import de.setsoftware.reviewtool.config.IReviewConfigurable;
import de.setsoftware.reviewtool.model.TicketLinkSettings;
import de.setsoftware.reviewtool.ticketconnectors.jira.JiraPersistence;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JiraConnectorConfigurator
implements IConfigurator {
    public Set<String> getRelevantElementNames() {
        return Collections.singleton("jiraTicketStore");
    }

    public void configure(Element xml, IReviewConfigurable configurable) {
        String ticketLinkPattern = xml.getAttribute("ticketLinkPattern");
        String ticketLinkText = xml.getAttribute("ticketLinkText");
        TicketLinkSettings linkSettings = !ticketLinkPattern.isEmpty() ? new TicketLinkSettings(ticketLinkPattern, ticketLinkText.isEmpty() ? "Open ticket" : ticketLinkText) : null;
        JiraPersistence p = new JiraPersistence(xml.getAttribute("url"), xml.getAttribute("reviewRemarkField"), xml.getAttribute("reviewState"), xml.getAttribute("implementationState"), xml.getAttribute("readyForReviewState"), xml.getAttribute("rejectedState"), xml.getAttribute("doneState"), xml.getAttribute("user"), xml.getAttribute("password"), linkSettings, this.toFile(xml.getAttribute("cookieFile")), xml.getAttribute("oauthIssuer"), xml.getAttribute("oauthAudience"), xml.getAttribute("oauthClientID"), xml.getAttribute("oauthClientSecret"));
        NodeList filters = xml.getElementsByTagName("filter");
        int i = 0;
        while (i < filters.getLength()) {
            Element filter = (Element)filters.item(i);
            p.addFilter(filter.getAttribute("name"), filter.getAttribute("jql"), Boolean.parseBoolean(filter.getAttribute("forReview")));
            ++i;
        }
        configurable.configureWith((Object)p);
    }

    private File toFile(String attribute) {
        if (attribute == null || attribute.isEmpty()) {
            return null;
        }
        return new File(attribute);
    }
}

