/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.ticketconnectors.jira;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

final class BearerTokenProvider {
    private BearerTokenProvider() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final String createBearerToken(String oauthIssuer, String oauthAudience, String oauthClientID, String oauthClientSecret) throws IOException {
        String issuerUri = String.valueOf(oauthIssuer) + "oauth/token";
        HttpURLConnection c = (HttpURLConnection)new URL(issuerUri).openConnection();
        c.setRequestMethod("POST");
        c.addRequestProperty("Content-Type", "application/json");
        c.setDoOutput(true);
        c.connect();
        JsonObject data = new JsonObject();
        data.add("client_id", oauthClientID);
        data.add("client_secret", oauthClientSecret);
        data.add("audience", oauthAudience);
        data.add("grant_type", "client_credentials");
        Throwable throwable = null;
        Object var8_10 = null;
        try (OutputStream out = c.getOutputStream();){
            out.write(data.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
        try {
            throwable = null;
            var8_10 = null;
            try {
                InputStream input = c.getInputStream();
                try {
                    String string;
                    block28: {
                        InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);
                        try {
                            JsonObject json = Json.parse((Reader)reader).asObject();
                            String bearerToken = json.getString("access_token", null);
                            String[] tokenParts = bearerToken.split("\\.");
                            if (tokenParts.length != 3) {
                                throw new IOException("Received invalid bearer token");
                            }
                            JsonObject jsonHeader = Json.parse((String)BearerTokenProvider.decodeBase64EncodedString(tokenParts[0])).asObject();
                            String type = jsonHeader.get("typ").asString();
                            if (!type.equals("JWT")) {
                                throw new IOException("JSON web token expected: " + type);
                            }
                            JsonObject jsonData = Json.parse((String)BearerTokenProvider.decodeBase64EncodedString(tokenParts[1])).asObject();
                            String jwtAudience = jsonData.get("aud").asString();
                            if (!jwtAudience.equals(oauthAudience)) {
                                throw new IOException("Invalid audience in token: " + jwtAudience);
                            }
                            String jwtIssuer = jsonData.get("iss").asString();
                            if (!jwtIssuer.equals(oauthIssuer)) {
                                throw new IOException("Invalid issuer in token: " + jwtIssuer);
                            }
                            string = bearerToken;
                            return string;
                        }
                        finally {
                            if (reader == null) break block28;
                            reader.close();
                        }
                    }
                    if (input != null) {
                        input.close();
                    }
                    c.disconnect();
                    return string;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (input == null) throw throwable;
                    input.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (Throwable throwable5) {
            c.disconnect();
            throw throwable5;
        }
    }

    private static String decodeBase64EncodedString(String input) {
        return new String(Base64.getUrlDecoder().decode(input), StandardCharsets.ISO_8859_1);
    }
}

