/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.ordering;

import de.setsoftware.reviewtool.base.Logger;
import de.setsoftware.reviewtool.model.api.IClassification;
import de.setsoftware.reviewtool.model.api.IFragment;
import de.setsoftware.reviewtool.model.changestructure.IStopOrdering;
import de.setsoftware.reviewtool.model.changestructure.Stop;
import de.setsoftware.reviewtool.model.changestructure.TourElement;
import de.setsoftware.reviewtool.ordering.ChangePart;
import de.setsoftware.reviewtool.ordering.OrderingInfo;
import de.setsoftware.reviewtool.ordering.RelationMatcher;
import de.setsoftware.reviewtool.ordering.TourHierarchyBuilder;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.MatchSet;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.TourCalculator;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.TourCalculatorControl;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class StopOrdering
implements IStopOrdering {
    private final List<RelationMatcher> relationTypes;

    public StopOrdering(List<RelationMatcher> relationTypes) {
        this.relationTypes = new ArrayList<RelationMatcher>(relationTypes);
    }

    public List<? extends TourElement> groupAndSort(List<Stop> stops, TourCalculatorControl isCanceled, Set<? extends IClassification> irrelevantCategories) throws InterruptedException {
        List<ChangePart> changeParts = ChangePart.groupToMinimumGranularity(stops, irrelevantCategories);
        Logger.info((String)("initial change parts: " + changeParts.size()));
        TourCalculator.checkInterruption((TourCalculatorControl)isCanceled);
        ArrayList<OrderingInfo> orderingInfos = new ArrayList<OrderingInfo>();
        for (RelationMatcher m : this.relationTypes) {
            if (isCanceled.isFastModeNeeded()) break;
            orderingInfos.addAll(m.determineMatches(changeParts, isCanceled));
            TourCalculator.checkInterruption((TourCalculatorControl)isCanceled);
        }
        Logger.info((String)("change parts before sorting: " + changeParts.size()));
        TourCalculator calculator = TourCalculator.calculateFor(changeParts, StopOrdering.getMatchSets(orderingInfos), this.nameAndLineComparator(), (TourCalculatorControl)isCanceled);
        List sorted = calculator.getTour();
        Logger.info((String)("sorted change parts: " + sorted.size()));
        TourHierarchyBuilder hierarchyBuilder = new TourHierarchyBuilder(sorted);
        for (OrderingInfo o : orderingInfos) {
            hierarchyBuilder.createSubtourIfPossible(o);
        }
        TourCalculator.checkInterruption((TourCalculatorControl)isCanceled);
        return hierarchyBuilder.getTopmostElements();
    }

    private Comparator<ChangePart> nameAndLineComparator() {
        return new Comparator<ChangePart>(){

            @Override
            public int compare(ChangePart o1, ChangePart o2) {
                Stop s1 = o1.getStops().get(0);
                Stop s2 = o2.getStops().get(0);
                int cmp = s1.getOriginalMostRecentFile().getPath().compareTo(s2.getOriginalMostRecentFile().getPath());
                if (cmp != 0) {
                    return cmp;
                }
                return Integer.compare(this.getLine(s1), this.getLine(s2));
            }

            private int getLine(Stop s) {
                IFragment fragment = s.getOriginalMostRecentFragment();
                return fragment == null ? -1 : fragment.getFrom().getLine();
            }
        };
    }

    private static List<MatchSet<ChangePart>> getMatchSets(List<OrderingInfo> orderingInfos) {
        ArrayList<MatchSet<ChangePart>> ret = new ArrayList<MatchSet<ChangePart>>();
        for (OrderingInfo o : orderingInfos) {
            ret.add(o.getMatchSet());
        }
        return ret;
    }
}

