/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.ordering;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.TypeDeclaration;
import de.setsoftware.reviewtool.base.Logger;
import de.setsoftware.reviewtool.base.Multimap;
import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import de.setsoftware.reviewtool.model.api.IStop;
import de.setsoftware.reviewtool.ordering.ChangePart;
import de.setsoftware.reviewtool.ordering.HierarchyExplicitness;
import de.setsoftware.reviewtool.ordering.LineRangeMap;
import de.setsoftware.reviewtool.ordering.MethodKey;
import de.setsoftware.reviewtool.ordering.OrderingInfo;
import de.setsoftware.reviewtool.ordering.OrderingInfoImpl;
import de.setsoftware.reviewtool.ordering.RelationMatcher;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.TourCalculator;
import de.setsoftware.reviewtool.ordering.efficientalgorithm.TourCalculatorControl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class JavaParserBasedRelation
implements RelationMatcher {
    private final HierarchyExplicitness explicitness;

    public JavaParserBasedRelation(HierarchyExplicitness explicitness) {
        this.explicitness = explicitness;
    }

    @Override
    public Collection<? extends OrderingInfo> determineMatches(List<ChangePart> changeParts, TourCalculatorControl control) throws InterruptedException {
        Multimap groupedByFile = new Multimap();
        for (ChangePart c : changeParts) {
            IRevisionedFile file;
            IStop stop;
            if (c.isFullyIrrelevantForReview() || (stop = (IStop)c.getStops().get(0)).isBinaryChange() || !(file = stop.getMostRecentFile()).getPath().endsWith(".java")) continue;
            groupedByFile.put((Object)file, (Object)c);
        }
        Multimap centerCandidates = new Multimap();
        Multimap rayCandidates = new Multimap();
        for (Map.Entry e : groupedByFile.entrySet()) {
            TourCalculator.checkInterruption((TourCalculatorControl)control);
            try {
                byte[] fileContent = ((IRevisionedFile)e.getKey()).getContents();
                if (fileContent == null) continue;
                LineRangeMap lineRanges = new LineRangeMap((List)e.getValue());
                CompilationUnit c = JavaParser.parse((InputStream)new ByteArrayInputStream(fileContent));
                for (TypeDeclaration t : c.getTypes()) {
                    this.handleType((Multimap<MethodKey, ChangePart>)centerCandidates, (Multimap<MethodKey, ChangePart>)rayCandidates, lineRanges, t);
                }
            }
            catch (Exception e1) {
                Logger.info((String)("Problem while parsing file " + e.getKey() + ": " + e1));
            }
        }
        ArrayList<OrderingInfo> ret = new ArrayList<OrderingInfo>();
        for (Map.Entry e : centerCandidates.entrySet()) {
            List rest;
            if (((List)e.getValue()).size() > 1 || (rest = rayCandidates.get((Object)((MethodKey)e.getKey()))).isEmpty()) continue;
            ret.add(OrderingInfoImpl.star(this.explicitness, this.toRelationKey((MethodKey)e.getKey()), (ChangePart)((List)e.getValue()).get(0), rest));
        }
        return ret;
    }

    protected abstract String toRelationKey(MethodKey var1);

    protected abstract void handleType(Multimap<MethodKey, ChangePart> var1, Multimap<MethodKey, ChangePart> var2, LineRangeMap var3, TypeDeclaration<?> var4);
}

