/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.base.IMultimap;
import de.setsoftware.reviewtool.base.Multimap;
import de.setsoftware.reviewtool.base.Util;
import de.setsoftware.reviewtool.model.api.IBinaryChange;
import de.setsoftware.reviewtool.model.api.IClassification;
import de.setsoftware.reviewtool.model.api.IFragment;
import de.setsoftware.reviewtool.model.api.IFragmentTracer;
import de.setsoftware.reviewtool.model.api.IHunk;
import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import de.setsoftware.reviewtool.model.api.IStop;
import de.setsoftware.reviewtool.model.api.ITextualChange;
import de.setsoftware.reviewtool.model.api.IWorkingCopy;
import de.setsoftware.reviewtool.model.changestructure.Classification;
import de.setsoftware.reviewtool.model.changestructure.Hunk;
import de.setsoftware.reviewtool.model.changestructure.TourElement;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Stop
extends TourElement
implements IStop {
    private final IWorkingCopy wc;
    private final Map<IRevisionedFile, IRevisionedFile> historyOrder;
    private final Multimap<IRevisionedFile, IHunk> history;
    private final IRevisionedFile mostRecentFile;
    private final IFragment mostRecentFragment;
    private transient IRevisionedFile mostRecentFileConsideringLocalChanges;
    private transient IFragment mostRecentFragmentConsideringLocalChanges;
    private final IClassification[] classification;

    public Stop(ITextualChange change, IFragment traceFragment) {
        this.wc = change.getWorkingCopy();
        this.historyOrder = new LinkedHashMap<IRevisionedFile, IRevisionedFile>();
        this.historyOrder.put(change.getFrom(), change.getTo());
        this.history = new Multimap();
        this.history.put(change.getFrom(), new Hunk(change));
        this.mostRecentFile = traceFragment.getFile();
        this.mostRecentFragment = traceFragment;
        this.mostRecentFileConsideringLocalChanges = null;
        this.mostRecentFragmentConsideringLocalChanges = null;
        this.classification = change.getClassification();
    }

    public Stop(IBinaryChange change, IRevisionedFile traceFile) {
        this.wc = change.getWorkingCopy();
        this.historyOrder = new LinkedHashMap<IRevisionedFile, IRevisionedFile>();
        this.historyOrder.put(change.getFrom(), change.getTo());
        this.history = new Multimap();
        this.mostRecentFile = traceFile;
        this.mostRecentFragment = null;
        this.mostRecentFileConsideringLocalChanges = null;
        this.mostRecentFragmentConsideringLocalChanges = null;
        this.classification = change.getClassification();
    }

    private Stop(IWorkingCopy wc, Map<IRevisionedFile, IRevisionedFile> historyOrder, Multimap<IRevisionedFile, IHunk> history, IRevisionedFile mostRecentFile, IFragment mostRecentFragment, IRevisionedFile mostRecentFileConsideringLocalChanges, IFragment mostRecentFragmentConsideringLocalChanges, IClassification[] classification) {
        this.wc = wc;
        this.historyOrder = historyOrder;
        this.history = history;
        this.mostRecentFile = mostRecentFile;
        this.mostRecentFragment = mostRecentFragment;
        this.mostRecentFileConsideringLocalChanges = mostRecentFileConsideringLocalChanges;
        this.mostRecentFragmentConsideringLocalChanges = mostRecentFragmentConsideringLocalChanges;
        this.classification = classification;
    }

    @Override
    public IWorkingCopy getWorkingCopy() {
        return this.wc;
    }

    @Override
    public boolean isDetailedFragmentKnown() {
        return this.mostRecentFragment != null;
    }

    @Override
    public IFragment getOriginalMostRecentFragment() {
        return this.mostRecentFragment;
    }

    @Override
    public IRevisionedFile getOriginalMostRecentFile() {
        return this.mostRecentFile;
    }

    @Override
    public synchronized IFragment getMostRecentFragment() {
        return this.mostRecentFragmentConsideringLocalChanges != null ? this.mostRecentFragmentConsideringLocalChanges : this.mostRecentFragment;
    }

    @Override
    public synchronized IRevisionedFile getMostRecentFile() {
        return this.mostRecentFileConsideringLocalChanges != null ? this.mostRecentFileConsideringLocalChanges : this.mostRecentFile;
    }

    @Override
    public synchronized void updateMostRecentData(IFragmentTracer tracer) {
        if (this.mostRecentFragment != null) {
            List<? extends IFragment> fragments = tracer.traceFragment(this.wc.getFileHistoryGraph(), this.mostRecentFragment, true);
            for (IFragment iFragment : fragments) {
                if (this.wc.toAbsolutePathInWc(iFragment.getFile().getPath()) == null) continue;
                this.mostRecentFragmentConsideringLocalChanges = iFragment;
                break;
            }
        }
        List<IRevisionedFile> files = tracer.traceFile(this.wc.getFileHistoryGraph(), this.mostRecentFile, true);
        for (IRevisionedFile iRevisionedFile : files) {
            if (this.wc.toAbsolutePathInWc(iRevisionedFile.getPath()) == null) continue;
            this.mostRecentFileConsideringLocalChanges = iRevisionedFile;
            break;
        }
    }

    @Override
    public Map<IRevisionedFile, IRevisionedFile> getHistory() {
        return Collections.unmodifiableMap(this.historyOrder);
    }

    @Override
    public IMultimap<IRevisionedFile, IHunk> getHunks() {
        return this.history.readOnlyView();
    }

    public List<IHunk> getContentFor(IRevisionedFile revision) {
        return this.history.get(revision);
    }

    @Override
    public boolean isBinaryChange() {
        return this.history.isEmpty();
    }

    public boolean canBeMergedWith(IStop other) {
        if (!this.mostRecentFile.equals(other.getOriginalMostRecentFile())) {
            return false;
        }
        if (this.mostRecentFragment == null) {
            return other.getOriginalMostRecentFragment() == null;
        }
        if (other.getOriginalMostRecentFragment() == null) {
            return false;
        }
        boolean fragmentsMergeable = this.mostRecentFragment.canBeMergedWith(other.getOriginalMostRecentFragment());
        if (Arrays.equals(this.getClassification(), other.getClassification())) {
            return fragmentsMergeable;
        }
        return fragmentsMergeable && !this.mostRecentFragment.isNeighboring(other.getOriginalMostRecentFragment());
    }

    public Stop merge(Stop other) {
        assert (this.canBeMergedWith(other));
        LinkedHashMap<IRevisionedFile, IRevisionedFile> mergedHistoryOrder = new LinkedHashMap<IRevisionedFile, IRevisionedFile>(this.historyOrder);
        mergedHistoryOrder.putAll(other.historyOrder);
        Multimap<IRevisionedFile, IHunk> mergedHistory = new Multimap<IRevisionedFile, IHunk>();
        mergedHistory.putAll(this.history);
        mergedHistory.putAll(other.getHunks());
        mergedHistory.sortValues();
        return new Stop(this.wc, mergedHistoryOrder, mergedHistory, this.mostRecentFile, this.mostRecentFragment == null ? null : this.mostRecentFragment.merge(other.mostRecentFragment), this.mostRecentFileConsideringLocalChanges, this.mostRecentFragmentConsideringLocalChanges == null ? null : this.mostRecentFragmentConsideringLocalChanges.merge(other.mostRecentFragmentConsideringLocalChanges), Classification.merge(this.classification, other.classification));
    }

    public String toString() {
        return "Stop " + (this.classification.length > 0 ? Arrays.toString(this.classification) : "") + " at " + (this.mostRecentFragment != null ? this.mostRecentFragment : this.mostRecentFile);
    }

    public int hashCode() {
        return this.mostRecentFragment != null ? this.mostRecentFragment.hashCode() : this.mostRecentFile.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Stop)) {
            return false;
        }
        Stop s = (Stop)o;
        return this.mostRecentFile.equals(s.mostRecentFile) && Util.sameOrEquals(this.mostRecentFragment, s.mostRecentFragment) && this.historyOrder.equals(s.historyOrder) && this.history.equals(s.history) && Arrays.equals(this.classification, s.classification);
    }

    public File getAbsoluteFile() {
        return this.getMostRecentFile().toLocalPath(this.wc).getAbsoluteFile();
    }

    @Override
    public int getNumberOfFragments() {
        int ret = 1;
        for (Map.Entry<IRevisionedFile, List<IHunk>> e : this.history.entrySet()) {
            ret += e.getValue().size();
        }
        return ret;
    }

    @Override
    public int getNumberOfAddedLines() {
        return this.mostRecentFragment == null ? 0 : this.mostRecentFragment.getNumberOfLines();
    }

    @Override
    public int getNumberOfRemovedLines() {
        int ret = 0;
        for (IRevisionedFile oldestFile : this.getHistoryRoots()) {
            for (IHunk hunk : this.getContentFor(oldestFile)) {
                ret += hunk.getSource().getNumberOfLines();
            }
        }
        return ret;
    }

    private Set<IRevisionedFile> getHistoryRoots() {
        LinkedHashSet<IRevisionedFile> ret = new LinkedHashSet<IRevisionedFile>(this.historyOrder.keySet());
        ret.removeAll(this.historyOrder.values());
        return ret;
    }

    @Override
    public boolean isIrrelevantForReview(Set<? extends IClassification> irrelevantCategories) {
        IClassification[] iClassificationArray = this.classification;
        int n = this.classification.length;
        int n2 = 0;
        while (n2 < n) {
            IClassification c = iClassificationArray[n2];
            if (irrelevantCategories.contains(c)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public IClassification[] getClassification() {
        return this.classification;
    }

    @Override
    protected void fillStopsInto(List<Stop> buffer) {
        buffer.add(this);
    }
}

