/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.base.IPartiallyComparable;
import de.setsoftware.reviewtool.model.api.ILocalRevision;
import de.setsoftware.reviewtool.model.api.IRepoRevision;
import de.setsoftware.reviewtool.model.api.IRepository;
import de.setsoftware.reviewtool.model.api.IRevision;
import de.setsoftware.reviewtool.model.api.IRevisionVisitor;
import de.setsoftware.reviewtool.model.api.IRevisionVisitorE;
import de.setsoftware.reviewtool.model.api.IUnknownRevision;

public final class RepoRevision<RevIdT extends IPartiallyComparable<RevIdT>>
implements IRepoRevision<RevIdT> {
    private static final long serialVersionUID = 1180259541435591492L;
    private final IRepository repo;
    private final RevIdT id;

    RepoRevision(RevIdT id, IRepository repo) {
        this.id = id;
        this.repo = repo;
    }

    @Override
    public IRepository getRepository() {
        return this.repo;
    }

    @Override
    public String toString() {
        return this.id.toString();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof RepoRevision)) {
            return false;
        }
        RepoRevision r = (RepoRevision)o;
        return this.repo == r.repo && this.id.equals(r.id);
    }

    @Override
    public <R> R accept(IRevisionVisitor<R> visitor) {
        return visitor.handleRepoRevision(this);
    }

    @Override
    public <R, E extends Throwable> R accept(IRevisionVisitorE<R, E> visitor) throws E {
        return visitor.handleRepoRevision(this);
    }

    @Override
    public RevIdT getId() {
        return this.id;
    }

    @Override
    public boolean le(IRevision other) {
        return other.accept(new IRevisionVisitor<Boolean>(){

            @Override
            public Boolean handleLocalRevision(ILocalRevision revision) {
                return true;
            }

            @Override
            public Boolean handleRepoRevision(IRepoRevision<?> revision) {
                if (RepoRevision.this.id.getClass().equals(revision.getId().getClass())) {
                    IPartiallyComparable otherId = (IPartiallyComparable)revision.getId();
                    if (RepoRevision.this.repo.equals(revision.getRepository()) && RepoRevision.this.id.le(otherId)) {
                        return true;
                    }
                    return false;
                }
                return false;
            }

            @Override
            public Boolean handleUnknownRevision(IUnknownRevision revision) {
                return false;
            }
        });
    }
}

