/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.model.api.IFileDiff;
import de.setsoftware.reviewtool.model.api.IFileHistoryGraph;
import de.setsoftware.reviewtool.model.api.IFileHistoryNode;
import de.setsoftware.reviewtool.model.api.IFragment;
import de.setsoftware.reviewtool.model.api.IFragmentTracer;
import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class FragmentTracer
implements IFragmentTracer {
    public List<IFragment> traceFragment(IFileHistoryGraph fileHistoryGraph, IFragment fragment, boolean ignoreNonLocalCopies) {
        ArrayList<IFragment> result = new ArrayList<IFragment>();
        IRevisionedFile file = fragment.getFile();
        IFileHistoryNode node = fileHistoryGraph.getNodeFor(file);
        if (node != null) {
            for (IRevisionedFile leafRevision : fileHistoryGraph.getLatestFiles(file, ignoreNonLocalCopies)) {
                IFileHistoryNode descendant = fileHistoryGraph.getNodeFor(leafRevision);
                Set<? extends IFileDiff> fileDiffs = descendant.buildHistories(node);
                for (IFileDiff iFileDiff : fileDiffs) {
                    IFragment lastFragment = iFileDiff.traceFragment(fragment);
                    result.add(lastFragment);
                }
            }
        }
        return result;
    }

    @Override
    public List<IRevisionedFile> traceFile(IFileHistoryGraph fileHistoryGraph, IRevisionedFile file, boolean ignoreNonLocalCopies) {
        ArrayList<IRevisionedFile> result = new ArrayList<IRevisionedFile>();
        IFileHistoryNode node = fileHistoryGraph.getNodeFor(file);
        if (node != null) {
            for (IRevisionedFile leafRevision : fileHistoryGraph.getLatestFiles(file, ignoreNonLocalCopies)) {
                result.add(leafRevision);
            }
        }
        return result;
    }
}

