/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model.changestructure;

import de.setsoftware.reviewtool.base.ReviewtoolException;
import de.setsoftware.reviewtool.model.api.IDelta;
import de.setsoftware.reviewtool.model.api.IFragment;
import de.setsoftware.reviewtool.model.api.IFragmentList;
import de.setsoftware.reviewtool.model.api.IPositionInText;
import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import de.setsoftware.reviewtool.model.api.IncompatibleFragmentException;
import de.setsoftware.reviewtool.model.changestructure.FragmentList;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class Fragment
implements IFragment {
    private static final long serialVersionUID = 8223980588230543842L;
    private final IRevisionedFile file;
    private final IPositionInText from;
    private final IPositionInText to;
    private final Set<IFragment> origins;
    private String content;

    Fragment(IRevisionedFile file, IPositionInText from, IPositionInText to, IFragment ... origins) {
        this(file, from, to, Arrays.asList(origins));
    }

    Fragment(IRevisionedFile file, IPositionInText from, IPositionInText to, Collection<? extends IFragment> origins) {
        this(file, from, to, Fragment.combineOrigins(origins));
    }

    private Fragment(IRevisionedFile file, IPositionInText from, IPositionInText to, Set<? extends IFragment> origins) {
        assert (file != null);
        assert (from != null);
        assert (to != null);
        this.file = file;
        this.from = from;
        this.to = to;
        this.origins = new LinkedHashSet<IFragment>();
        if (origins.size() != 1 || !origins.iterator().next().equals(this)) {
            this.origins.addAll(origins);
        }
    }

    private static Set<? extends IFragment> combineOrigins(Collection<? extends IFragment> origins) {
        LinkedHashSet<? extends IFragment> newOrigins = new LinkedHashSet<IFragment>();
        for (IFragment iFragment : origins) {
            newOrigins.addAll(iFragment.getOrigins());
        }
        return newOrigins;
    }

    public static IFragment createWithContent(IRevisionedFile file, IPositionInText from, IPositionInText to, String content) {
        Fragment ret = new Fragment(file, from, to, new IFragment[0]);
        ret.content = content;
        return ret;
    }

    @Override
    public IRevisionedFile getFile() {
        return this.file;
    }

    @Override
    public IPositionInText getFrom() {
        return this.from;
    }

    @Override
    public IPositionInText getTo() {
        return this.to;
    }

    @Override
    public boolean isInline() {
        return this.from.getLine() == this.to.getLine();
    }

    @Override
    public IDelta getSize() {
        return this.to.minus(this.from);
    }

    public Set<IFragment> getOrigins() {
        if (this.isOrigin()) {
            LinkedHashSet<Fragment> result = new LinkedHashSet<Fragment>();
            result.add(this);
            return Collections.unmodifiableSet(result);
        }
        return Collections.unmodifiableSet(this.origins);
    }

    @Override
    public String getContentFullLines() {
        if (this.content == null) {
            this.content = this.extractContent();
        }
        return this.content;
    }

    @Override
    public String getContent() {
        String s = this.getContentFullLines();
        if (s.isEmpty()) {
            return s;
        }
        if (this.to.getColumn() > 1) {
            int discardFromEnd = Fragment.countCharsInLastLine(s) - this.to.getColumn() + 1;
            int endIndex = s.length() - discardFromEnd;
            return s.substring(this.from.getColumn() - 1, endIndex);
        }
        return s.substring(this.from.getColumn() - 1);
    }

    private static int countCharsInLastLine(String s) {
        int count = s.endsWith("\n") ? 1 : 0;
        int i = s.length() - count - 1;
        while (i >= 0) {
            if (s.charAt(i) == '\n') break;
            ++count;
            --i;
        }
        return count;
    }

    private String extractContent() {
        byte[] contents;
        if (this.isDeletion() && this.to.getColumn() == 1) {
            return "";
        }
        try {
            contents = this.file.getContents();
        }
        catch (Exception e) {
            return "?";
        }
        try {
            String lineContent;
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(contents), "UTF-8"));
            StringBuilder ret = new StringBuilder();
            int lineNumber = 1;
            while ((lineContent = r.readLine()) != null) {
                if (lineNumber >= this.from.getLine()) {
                    if (lineNumber < this.to.getLine()) {
                        ret.append(lineContent).append('\n');
                    } else if (lineNumber == this.to.getLine() && this.to.getColumn() > 1) {
                        ret.append(lineContent).append('\n');
                    }
                }
                ++lineNumber;
            }
            return ret.toString();
        }
        catch (IOException e) {
            throw new AssertionError("unexpected exception", e);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.from.toString());
        result.append(" - ");
        result.append(this.to.toString());
        result.append(" in ");
        result.append(this.file.toString());
        if (this.origins.size() > 1) {
            result.append("\norigins: ");
            result.append(this.origins.toString().replace(", ", ",\n  "));
        } else if (this.origins.size() == 1) {
            result.append("\norigin: ");
            result.append(this.origins.iterator().next());
        }
        return result.toString();
    }

    @Override
    public boolean isOrigin() {
        return this.origins.isEmpty();
    }

    @Override
    public boolean isNeighboring(IFragment other) {
        if (!this.file.equals(other.getFile())) {
            return false;
        }
        return this.isAdjacentTo(other);
    }

    @Override
    public boolean overlaps(IFragment other) {
        return this.to.compareTo(other.getFrom()) > 0 && this.from.compareTo(other.getTo()) < 0;
    }

    @Override
    public boolean isAdjacentTo(IFragment other) {
        return this.to.equals(other.getFrom()) || this.from.equals(other.getTo());
    }

    @Override
    public boolean containsChangeInOneOf(Collection<? extends IFragment> fragments) {
        for (IFragment origin : this.getOrigins()) {
            for (IFragment iFragment : fragments) {
                if (!origin.overlaps(iFragment) && !origin.isAdjacentTo(iFragment)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public IFragment adjoin(IFragment other) {
        assert (this.isAdjacentTo(other));
        if (this.to.equals(other.getFrom())) {
            return new Fragment(this.file, this.from, other.getTo(), this, other);
        }
        return new Fragment(this.file, other.getFrom(), this.to, this, other);
    }

    @Override
    public IFragmentList subtract(IFragment other) {
        if (!this.overlaps(other)) {
            return new FragmentList(this);
        }
        try {
            FragmentList fragmentList = new FragmentList();
            if (this.from.lessThan(other.getFrom())) {
                fragmentList.addFragment(new Fragment(this.file, this.from, other.getFrom(), this));
            }
            if (other.getTo().lessThan(this.to)) {
                fragmentList.addFragment(new Fragment(this.file, other.getTo(), this.to, this));
            }
            return fragmentList;
        }
        catch (IncompatibleFragmentException e) {
            throw new ReviewtoolException(e);
        }
    }

    @Override
    public IFragmentList subtract(IFragmentList other) {
        return new FragmentList(this).subtract(other);
    }

    @Override
    public boolean canBeMergedWith(IFragment other) {
        if (!this.file.equals(other.getFile())) {
            return false;
        }
        return this.isAdjacentTo(other) || this.overlaps(other);
    }

    @Override
    public IFragment merge(IFragment other) {
        if (other.getFrom().lessThan(this.getFrom())) {
            return other.merge(this);
        }
        assert (this.canBeMergedWith(other));
        IPositionInText minFrom = this.getFrom();
        IPositionInText maxTo = this.to.lessThan(other.getTo()) ? other.getTo() : this.to;
        return new Fragment(this.file, minFrom, maxTo, this, other);
    }

    @Override
    public boolean isDeletion() {
        return this.to.equals(this.from);
    }

    @Override
    public IFragment setFile(IRevisionedFile newFile) {
        return new Fragment(newFile, this.from, this.to, this);
    }

    public int hashCode() {
        return this.from.hashCode() + 31 * this.file.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Fragment)) {
            return false;
        }
        Fragment other = (Fragment)obj;
        return this.file.equals(other.file) && this.from.equals(other.from) && this.to.equals(other.to) && this.origins.equals(other.origins);
    }

    @Override
    public int getNumberOfLines() {
        return this.to.getLine() - this.from.getLine();
    }

    @Override
    public IFragment adjust(IDelta delta) {
        return new Fragment(this.file, this.from.plus(delta), this.to.plus(this.isInline() ? delta : delta.ignoreColumnOffset()), this);
    }

    @Override
    public int compareTo(IFragment o) {
        int from = this.getFrom().compareTo(o.getFrom());
        return from != 0 ? from : this.getTo().compareTo(o.getTo());
    }
}

