/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.model;

import de.setsoftware.reviewtool.base.Logger;
import de.setsoftware.reviewtool.model.api.BackgroundJobExecutor;
import de.setsoftware.reviewtool.model.api.ChangeSourceException;
import de.setsoftware.reviewtool.model.api.IChangeSource;
import de.setsoftware.reviewtool.model.api.ICortProgressMonitor;
import de.setsoftware.reviewtool.model.remarks.FileLinePosition;
import de.setsoftware.reviewtool.model.remarks.FilePosition;
import de.setsoftware.reviewtool.model.remarks.GlobalPosition;
import de.setsoftware.reviewtool.model.remarks.Position;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class PositionTransformer {
    private static final long STALE_LIMIT_MS = 20000L;
    private static final long REALLY_OLD_LIMIT_MS = 3600000L;
    private static AtomicBoolean refreshRunning = new AtomicBoolean();
    private static volatile ConcurrentHashMap<String, PathChainNode> cache = null;
    private static volatile long cacheRefreshTime;
    private static volatile IChangeSource[] changeSources;
    private static volatile Supplier<Set<File>> projectPathSupplier;
    private static final ICortProgressMonitor NO_CANCEL_MONITOR;

    static {
        changeSources = new IChangeSource[0];
        NO_CANCEL_MONITOR = new ICortProgressMonitor(){

            @Override
            public void subTask(String name) {
            }

            @Override
            public boolean isCanceled() {
                return false;
            }

            @Override
            public void done() {
            }

            @Override
            public void beginTask(String name, int totalWork) {
            }
        };
    }

    public static Position toPosition(File path, int line) {
        if (path.isDirectory()) {
            return new GlobalPosition();
        }
        String filename = PositionTransformer.stripExtension(path.getName());
        if (filename.isEmpty()) {
            return new GlobalPosition();
        }
        List<File> possiblePaths = PositionTransformer.getCachedPathsForName(filename);
        if (possiblePaths == null) {
            return new GlobalPosition();
        }
        if (possiblePaths.size() == 1) {
            return PositionTransformer.createPos(path.getName(), line);
        }
        return PositionTransformer.createPos(PositionTransformer.getShortestUniqueName(path, possiblePaths), line);
    }

    private static String getShortestUniqueName(File resourcePath, List<File> possiblePaths) {
        String[] segments = PositionTransformer.segments(resourcePath);
        int suffixLength = 1;
        while (suffixLength < segments.length) {
            int count = PositionTransformer.countWithSameSuffix(segments, possiblePaths, suffixLength);
            if (count == 1) break;
            ++suffixLength;
        }
        return PositionTransformer.implodePath(segments, suffixLength);
    }

    private static int countWithSameSuffix(String[] resourcePathSegments, List<File> possiblePaths, int suffixLength) {
        int count = 0;
        for (File path : possiblePaths) {
            if (!PositionTransformer.sameSuffix(resourcePathSegments, PositionTransformer.segments(path), suffixLength)) continue;
            ++count;
        }
        return count;
    }

    private static boolean sameSuffix(String[] resourcePath, String[] otherPath, int suffixLength) {
        if (otherPath.length < suffixLength) {
            return false;
        }
        int i = suffixLength;
        while (i >= 1) {
            String seg1 = resourcePath[resourcePath.length - i];
            String seg2 = otherPath[otherPath.length - i];
            if (!seg1.equals(seg2)) {
                return false;
            }
            --i;
        }
        return true;
    }

    private static String implodePath(String[] segments, int suffixLength) {
        StringBuilder ret = new StringBuilder();
        int i = segments.length - suffixLength;
        while (i < segments.length) {
            if (i > segments.length - suffixLength) {
                ret.append('/');
            }
            ret.append(segments[i]);
            ++i;
        }
        return ret.toString();
    }

    private static synchronized List<File> getCachedPathsForName(String filename) {
        while (cache == null) {
            try {
                PositionTransformer.fillCache(NO_CANCEL_MONITOR);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            if (cache != null) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return Collections.emptyList();
            }
        }
        List<File> cachedPaths = PositionTransformer.toList(cache.get(filename));
        if (cachedPaths == null && PositionTransformer.cacheMightBeStale() || PositionTransformer.cacheIsReallyOld()) {
            PositionTransformer.refreshCacheInBackground();
        }
        return cachedPaths;
    }

    private static List<File> toList(PathChainNode startNode) {
        if (startNode == null) {
            return null;
        }
        ArrayList<File> ret = new ArrayList<File>();
        PathChainNode curNode = startNode;
        do {
            ret.add(curNode.path);
        } while ((curNode = curNode.next) != null);
        return ret;
    }

    private static boolean cacheMightBeStale() {
        return System.currentTimeMillis() - cacheRefreshTime > 20000L;
    }

    private static boolean cacheIsReallyOld() {
        return System.currentTimeMillis() - cacheRefreshTime > 3600000L;
    }

    private static void fillCache(ICortProgressMonitor monitor) throws InterruptedException {
        if (refreshRunning.compareAndSet(false, true)) {
            try {
                ForkJoinPool pool = new ForkJoinPool((Runtime.getRuntime().availableProcessors() + 1) / 2);
                ArrayList<ForkJoinTask<Void>> tasks = new ArrayList<ForkJoinTask<Void>>();
                ConcurrentHashMap<String, PathChainNode> newCache = new ConcurrentHashMap<String, PathChainNode>();
                for (File file : PositionTransformer.determineRootPaths()) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    tasks.add(pool.submit(new FillCacheAction(file, newCache)));
                }
                for (ForkJoinTask forkJoinTask : tasks) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    forkJoinTask.join();
                }
                pool.shutdown();
                cache = newCache;
                cacheRefreshTime = System.currentTimeMillis();
            }
            finally {
                refreshRunning.set(false);
            }
        }
    }

    private static Set<File> determineRootPaths() {
        LinkedHashSet<File> ret = new LinkedHashSet<File>();
        for (File projectPath : projectPathSupplier.get()) {
            ret.add(PositionTransformer.getWorkingCopyRoot(projectPath));
        }
        HashSet<File> childProjects = new HashSet<File>();
        for (File cur : ret) {
            if (!ret.contains(cur.getParentFile())) continue;
            childProjects.add(cur);
        }
        ret.removeAll(childProjects);
        return ret;
    }

    private static File getWorkingCopyRoot(File dir) {
        IChangeSource[] cs;
        IChangeSource[] iChangeSourceArray = cs = changeSources;
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            IChangeSource c = iChangeSourceArray[n2];
            try {
                File root = c.determineWorkingCopyRoot(dir);
                if (root != null) {
                    return root;
                }
            }
            catch (ChangeSourceException e) {
                Logger.warn("exception from changesource", e);
            }
            ++n2;
        }
        return dir;
    }

    private static void fillCacheIfEmpty(ICortProgressMonitor monitor) throws InterruptedException {
        if (cache != null) {
            return;
        }
        PositionTransformer.fillCache(monitor);
    }

    public static void initializeCacheInBackground() {
        BackgroundJobExecutor.execute("Review resource cache init", monitor -> {
            try {
                PositionTransformer.fillCacheIfEmpty(monitor);
                return null;
            }
            catch (InterruptedException e) {
                return e;
            }
        });
    }

    public static void refreshCacheInBackground() {
        BackgroundJobExecutor.execute("Review resource cache refresh", monitor -> {
            try {
                PositionTransformer.fillCache(monitor);
                return null;
            }
            catch (InterruptedException e) {
                return e;
            }
        });
    }

    private static String stripExtension(String name) {
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex >= 0) {
            return name.substring(0, dotIndex);
        }
        return name;
    }

    private static Position createPos(String shortName, int line) {
        if (line > 0) {
            return new FileLinePosition(shortName, line);
        }
        return new FilePosition(shortName);
    }

    public static File toPath(Position pos) {
        return PositionTransformer.toPath(pos.getShortFileName());
    }

    public static File toPath(String filename) {
        if (filename == null) {
            return null;
        }
        String[] segments = filename.split("/");
        String filenameWithoutExtension = PositionTransformer.stripExtension(segments[segments.length - 1]);
        List<File> paths = PositionTransformer.getCachedPathsForName(filenameWithoutExtension);
        if (paths == null) {
            return null;
        }
        if (segments.length == 1 && paths.size() == 1) {
            return paths.get(0);
        }
        File fittingPath = PositionTransformer.findFittingPath(segments, paths);
        if (fittingPath == null) {
            return null;
        }
        return fittingPath;
    }

    private static File findFittingPath(String[] segments, List<File> paths) {
        File result = null;
        for (File path : paths) {
            String[] pathSegments = PositionTransformer.segments(path);
            if (!PositionTransformer.sameSuffix(segments, pathSegments, segments.length) || result != null && pathSegments.length >= PositionTransformer.segments(result).length) continue;
            result = path;
        }
        return result;
    }

    private static String[] segments(File path) {
        Path p = path.toPath();
        String[] ret = new String[p.getNameCount()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = p.getName(i).toString();
            ++i;
        }
        return ret;
    }

    public static void setProjectSource(Supplier<Set<File>> projectPathSupplier2) {
        projectPathSupplier = projectPathSupplier2;
    }

    public static void setChangeSources(List<IChangeSource> list) {
        changeSources = list.toArray(new IChangeSource[list.size()]);
    }

    private static final class FillCacheAction
    extends RecursiveAction {
        private static final long serialVersionUID = -6349559047252339690L;
        private final File path;
        private final ConcurrentHashMap<String, PathChainNode> sharedMap;

        public FillCacheAction(File directory, ConcurrentHashMap<String, PathChainNode> sharedMap) {
            this.path = directory;
            this.sharedMap = sharedMap;
        }

        @Override
        protected void compute() {
            File[] children = this.path.listFiles();
            if (children == null) {
                return;
            }
            ArrayList<FillCacheAction> subActions = new ArrayList<FillCacheAction>();
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                String childName = child.getName();
                if (!childName.startsWith(".") && !childName.equals("bin")) {
                    if (child.isDirectory()) {
                        subActions.add(new FillCacheAction(new File(this.path, childName), this.sharedMap));
                    } else {
                        String childNameWithoutExtension = PositionTransformer.stripExtension(childName);
                        this.addToMap(childNameWithoutExtension, new File(this.path, childName));
                    }
                }
                ++n2;
            }
            FillCacheAction.invokeAll(subActions);
        }

        private void addToMap(String childNameWithoutExtension, File path) {
            PathChainNode newNode;
            PathChainNode oldNode;
            boolean success;
            do {
                oldNode = this.sharedMap.get(childNameWithoutExtension);
                newNode = new PathChainNode(path, oldNode);
            } while (!(success = oldNode == null ? this.sharedMap.putIfAbsent(childNameWithoutExtension, newNode) == null : this.sharedMap.replace(childNameWithoutExtension, oldNode, newNode)));
        }
    }

    private static final class PathChainNode {
        private final PathChainNode next;
        private final File path;

        public PathChainNode(File path2, PathChainNode oldNode) {
            this.next = oldNode;
            this.path = path2;
        }
    }
}

