/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.diffalgorithms;

public abstract class PathNode {
    private int posOld;
    private int posNew;
    private PathNode prev;

    public PathNode(int i, int j, PathNode prev) {
        this.posOld = i;
        this.posNew = j;
        this.prev = prev;
    }

    final int getPosOld() {
        return this.posOld;
    }

    final int getPosNew() {
        return this.posNew;
    }

    final PathNode getPrev() {
        return this.prev;
    }

    public abstract boolean isSnake();

    public final boolean isBootstrap() {
        return this.posOld < 0 || this.posNew < 0;
    }

    public abstract PathNode previousSnake();

    public String toString() {
        StringBuffer buf = new StringBuffer("[");
        PathNode node = this;
        while (node != null) {
            buf.append("(");
            buf.append(Integer.toString(node.posOld));
            buf.append(",");
            buf.append(Integer.toString(node.posNew));
            buf.append(")");
            node = node.prev;
        }
        buf.append("]");
        return buf.toString();
    }

    public final int getLengthNew() {
        return this.posNew - this.getStartPosNew();
    }

    public final int getStartPosNew() {
        return this.prev == null ? 0 : this.prev.posNew;
    }

    public final int getLengthOld() {
        return this.posOld - this.getStartPosOld();
    }

    public final int getStartPosOld() {
        return this.prev == null ? 0 : this.prev.posOld;
    }

    public final void moveUpwards(int steps) {
        this.posOld -= steps;
        this.posNew -= steps;
        if (this.prev != null) {
            this.prev.posOld -= steps;
            this.prev.posNew -= steps;
        }
    }

    public final void joinWithNextDiff() {
        assert (this.prev.getLengthNew() == 0);
        PathNode prevDiff = this.prev.prev;
        if (prevDiff == null) {
            this.prev = null;
        } else if (prevDiff.getPrev() == null) {
            this.prev.prev = null;
        } else {
            this.prev = prevDiff.getPrev();
        }
    }

    public final void enlargeBy(int length) {
        this.posOld += length;
        this.posNew += length;
    }
}

