/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.diffalgorithms;

import de.setsoftware.reviewtool.base.Pair;
import de.setsoftware.reviewtool.base.ReviewtoolException;
import de.setsoftware.reviewtool.diffalgorithms.FullFileView;
import de.setsoftware.reviewtool.diffalgorithms.MyersDiff;
import de.setsoftware.reviewtool.diffalgorithms.OneFileView;
import de.setsoftware.reviewtool.diffalgorithms.PathNode;
import de.setsoftware.reviewtool.diffalgorithms.StartLineSuitability;
import de.setsoftware.reviewtool.model.api.IDiffAlgorithm;
import de.setsoftware.reviewtool.model.api.IFragment;
import de.setsoftware.reviewtool.model.api.IRevisionedFile;
import de.setsoftware.reviewtool.model.changestructure.ChangestructureFactory;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class MyersSourceDiffAlgorithm
implements IDiffAlgorithm {
    private static final long serialVersionUID = -2135531518214950624L;

    MyersSourceDiffAlgorithm() {
    }

    @Override
    public List<Pair<IFragment, IFragment>> determineDiff(IRevisionedFile fileOldInfo, byte[] fileOldContent, IRevisionedFile fileNewInfo, byte[] fileNewContent, String charset) {
        FullFileView<String> fileOld = this.toLines(fileOldContent, charset);
        FullFileView<String> fileNew = this.toLines(fileNewContent, charset);
        PathNode path = new MyersDiff().buildPath(fileOld, fileNew);
        this.postprocessPath(path, fileOld, fileNew);
        List<Pair<IFragment, IFragment>> fragments = this.createFragmentsFromPath(path, fileOldInfo, fileOld, fileNewInfo, fileNew);
        Collections.reverse(fragments);
        return fragments;
    }

    private void postprocessPath(PathNode pathEnd, FullFileView<String> fileOld, FullFileView<String> fileNew) {
        this.makeBetterByMovingDiffsUpwards(pathEnd, fileNew);
        this.makeBetterByMovingLastDiffDownwards(pathEnd, fileOld, fileNew);
    }

    private void makeBetterByMovingLastDiffDownwards(PathNode pathEnd, FullFileView<String> fileOld, FullFileView<String> fileNew) {
        if (!pathEnd.isSnake()) {
            return;
        }
        int commonSuffixLength = pathEnd.getLengthOld();
        PathNode lastDiff = pathEnd.getPrev();
        assert (!lastDiff.isSnake());
        if (lastDiff.getLengthNew() == 0 && lastDiff.getLengthOld() == 0) {
            return;
        }
        int best = 0;
        StartLineSuitability suitabilityOfBest = lastDiff.getLengthNew() > 0 ? StartLineSuitability.determineFor(fileNew.getItem(lastDiff.getStartPosNew() + best)) : StartLineSuitability.determineFor(fileOld.getItem(lastDiff.getStartPosOld() + best));
        int move = 1;
        while (move <= commonSuffixLength && this.canMoveDownwards(lastDiff, move, fileOld, fileNew)) {
            StartLineSuitability currentSuitability = lastDiff.getLengthNew() > 0 ? StartLineSuitability.determineFor(fileNew.getItem(lastDiff.getStartPosNew() + move)) : StartLineSuitability.determineFor(fileOld.getItem(lastDiff.getStartPosOld() + move));
            if (currentSuitability.compareTo(suitabilityOfBest) > 0) {
                best = move;
                suitabilityOfBest = currentSuitability;
            }
            ++move;
        }
        if (best != 0) {
            lastDiff.moveUpwards(-best);
        }
    }

    private boolean canMoveDownwards(PathNode cur, int stepsDownwards, FullFileView<String> fileOld, FullFileView<String> fileNew) {
        assert (!cur.isSnake());
        int newPosOld = cur.getPosOld() + stepsDownwards - 1;
        int newPosNew = cur.getPosNew() + stepsDownwards - 1;
        return fileOld.getItem(newPosOld).equals(fileOld.getItem(newPosOld - cur.getLengthOld())) && fileNew.getItem(newPosNew).equals(fileNew.getItem(newPosNew - cur.getLengthNew()));
    }

    private void makeBetterByMovingDiffsUpwards(PathNode pathEnd, FullFileView<String> fileNew) {
        PathNode cur = pathEnd;
        while (cur != null) {
            if (cur.isSnake()) {
                cur = cur.getPrev();
                continue;
            }
            int best = 0;
            int move = 1;
            while (this.canMoveUpwards(cur, move, fileNew)) {
                if (this.isBetterStart(cur, move, best, fileNew) || this.willJoinTwoDiffs(cur, move)) {
                    best = move;
                }
                ++move;
            }
            if (best != 0) {
                cur.moveUpwards(best);
                if (cur.getPrev() != null && cur.getPrev().getLengthNew() == 0) {
                    cur.joinWithNextDiff();
                    continue;
                }
                cur = cur.getPrev();
                continue;
            }
            cur = cur.getPrev();
        }
    }

    private boolean willJoinTwoDiffs(PathNode cur, int move) {
        return cur.getPrev() != null && move == cur.getPrev().getLengthNew();
    }

    private boolean canMoveUpwards(PathNode cur, int stepsUpwards, FullFileView<String> file) {
        assert (!cur.isSnake());
        int newPos = cur.getPosNew() - stepsUpwards;
        return cur.getLengthOld() == 0 && newPos >= cur.getLengthNew() && (cur.getPrev() == null || cur.getStartPosNew() - stepsUpwards >= cur.getPrev().getStartPosNew()) && file.getItem(newPos).equals(file.getItem(newPos - cur.getLengthNew()));
    }

    private boolean isBetterStart(PathNode cur, int move, int best, FullFileView<String> fileNew) {
        StartLineSuitability suitabilityBest = StartLineSuitability.determineFor(fileNew.getItem(cur.getPosNew() - best));
        StartLineSuitability suitabilityMove = StartLineSuitability.determineFor(fileNew.getItem(cur.getPosNew() - move));
        return suitabilityMove.compareTo(suitabilityBest) > 0;
    }

    private List<Pair<IFragment, IFragment>> createFragmentsFromPath(PathNode pathEnd, IRevisionedFile fileOldInfo, OneFileView<String> fileOld, IRevisionedFile fileNewInfo, OneFileView<String> fileNew) {
        ArrayList<Pair<IFragment, IFragment>> ret = new ArrayList<Pair<IFragment, IFragment>>();
        PathNode cur = pathEnd;
        if (cur.isSnake()) {
            cur = cur.getPrev();
        }
        while (cur != null && cur.getPrev() != null && cur.getPrev().getPosNew() >= 0) {
            boolean isSingleLineChange;
            assert (!cur.isSnake());
            int endOld = cur.getPosOld();
            int endNew = cur.getPosNew();
            cur = cur.getPrev();
            int startOld = cur.getPosOld();
            int startNew = cur.getPosNew();
            boolean bl = isSingleLineChange = endOld - startOld == 1 && endNew - startNew == 1;
            if (isSingleLineChange) {
                ret.add(this.createInLineDiffFragment(fileOldInfo, fileNewInfo, startOld, fileOld.getItem(startOld), startNew, fileNew.getItem(startNew)));
            } else {
                IFragment original = ChangestructureFactory.createFragment(fileOldInfo, ChangestructureFactory.createPositionInText(startOld + 1, 1), ChangestructureFactory.createPositionInText(endOld + 1, 1));
                IFragment revised = ChangestructureFactory.createFragment(fileNewInfo, ChangestructureFactory.createPositionInText(startNew + 1, 1), ChangestructureFactory.createPositionInText(endNew + 1, 1));
                Pair<IFragment, IFragment> delta = Pair.create(original, revised);
                ret.add(delta);
            }
            if (!cur.isSnake()) continue;
            cur = cur.getPrev();
        }
        return ret;
    }

    private FullFileView<String> toLines(byte[] contents, String charset) {
        try {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(contents), charset));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = r.readLine()) != null) {
                lines.add(line);
            }
            return new FullFileView<String>(lines.toArray(new String[lines.size()]));
        }
        catch (IOException e) {
            throw new ReviewtoolException(e);
        }
    }

    private Pair<IFragment, IFragment> createInLineDiffFragment(IRevisionedFile fileOldInfo, IRevisionedFile fileNewInfo, int lineIndexOld, String content1, int lineIndexNew, String content2) {
        assert (!content1.equals(content2));
        int commonPrefixLength = this.determineCommonPrefixLength(content1, content2);
        int commonSuffixLength = this.determineCommonSuffixLength(content1.substring(commonPrefixLength), content2.substring(commonPrefixLength));
        return Pair.create(this.toInLineFileFragment(fileOldInfo, content1, lineIndexOld, commonPrefixLength, commonSuffixLength), this.toInLineFileFragment(fileNewInfo, content2, lineIndexNew, commonPrefixLength, commonSuffixLength));
    }

    private int determineCommonPrefixLength(String content1, String content2) {
        int max = Math.min(content1.length(), content2.length());
        int i = 0;
        while (i < max) {
            if (content1.charAt(i) != content2.charAt(i)) {
                return i;
            }
            ++i;
        }
        return max;
    }

    private int determineCommonSuffixLength(String content1, String content2) {
        int max = Math.min(content1.length(), content2.length());
        int i = 1;
        while (i <= max) {
            if (content1.charAt(content1.length() - i) != content2.charAt(content2.length() - i)) {
                return i - 1;
            }
            ++i;
        }
        return max;
    }

    private IFragment toInLineFileFragment(IRevisionedFile fileInfo, String line, int lineIndex, int prefixLength, int suffixLength) {
        return ChangestructureFactory.createFragment(fileInfo, ChangestructureFactory.createPositionInText(lineIndex + 1, prefixLength + 1), ChangestructureFactory.createPositionInText(lineIndex + 1, line.length() - suffixLength + 1));
    }
}

