/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.diffalgorithms;

import de.setsoftware.reviewtool.base.Multiset;
import de.setsoftware.reviewtool.diffalgorithms.ItemMatching;
import de.setsoftware.reviewtool.diffalgorithms.OneFileView;
import java.util.ArrayList;
import java.util.HashMap;

class LongestCommonSubsequence {
    private static final int CUTOFF_LIMIT = 1000000;

    LongestCommonSubsequence() {
    }

    public static <T> void determineLcs(OneFileView<T> file1, OneFileView<T> file2, ItemMatching<T> matching) {
        ArrayList<WorkItem> workStack = new ArrayList<WorkItem>();
        HashMap<WorkItem, WorkItem> bestSoFar = new HashMap<WorkItem, WorkItem>();
        int totalBestSum = Integer.MAX_VALUE;
        int bestPossibleResult = LongestCommonSubsequence.determineBestPossibleResult(file1, file2);
        workStack.add(new WorkItem(file1.getItemCount(), file2.getItemCount(), 0));
        while (!workStack.isEmpty()) {
            WorkItem bestItemSoFar;
            WorkItem cur = (WorkItem)workStack.remove(workStack.size() - 1);
            if (cur.sum >= totalBestSum || (bestItemSoFar = (WorkItem)bestSoFar.get(cur)) != null && bestItemSoFar.sum <= cur.sum) continue;
            bestSoFar.put(cur, cur);
            if (cur.pos1 == 0) {
                if (cur.pos2 == 0) {
                    totalBestSum = cur.sum;
                    if (cur.sum == bestPossibleResult) {
                        break;
                    }
                } else {
                    workStack.add(cur.up());
                }
            } else if (cur.pos2 == 0) {
                workStack.add(cur.left());
            } else if (file1.getItem(cur.pos1 - 1).equals(file2.getItem(cur.pos2 - 1))) {
                workStack.add(cur.same());
            } else if (cur.pos1 == cur.pos2) {
                workStack.add(cur.left());
                workStack.add(cur.up());
                workStack.add(cur.diagonal());
            } else if (cur.pos1 < cur.pos2) {
                workStack.add(cur.left());
                workStack.add(cur.diagonal());
                workStack.add(cur.up());
            } else {
                workStack.add(cur.up());
                workStack.add(cur.diagonal());
                workStack.add(cur.left());
            }
            if (bestSoFar.size() > 1000000) break;
        }
        WorkItem best = (WorkItem)bestSoFar.get(new WorkItem(0, 0, 0));
        if (best == null) {
            return;
        }
        WorkItem cur = best;
        while (true) {
            if (cur instanceof WorkItemU) {
                cur = (WorkItem)bestSoFar.get(new WorkItem(cur.pos1, cur.pos2 + 1, 0));
                continue;
            }
            if (cur instanceof WorkItemL) {
                cur = (WorkItem)bestSoFar.get(new WorkItem(cur.pos1 + 1, cur.pos2, 0));
                continue;
            }
            if (cur instanceof WorkItemD) {
                cur = (WorkItem)bestSoFar.get(new WorkItem(cur.pos1 + 1, cur.pos2 + 1, 0));
                continue;
            }
            if (!(cur instanceof WorkItemS)) break;
            matching.match(file1, cur.pos1, file2, cur.pos2);
            cur = (WorkItem)bestSoFar.get(new WorkItem(cur.pos1 + 1, cur.pos2 + 1, 0));
        }
    }

    private static <T> int determineBestPossibleResult(OneFileView<T> file1, OneFileView<T> file2) {
        Multiset<T> items1 = new Multiset<T>();
        int i = 0;
        while (i < file1.getItemCount()) {
            items1.add(file1.getItem(i));
            ++i;
        }
        int equalItemCount = 0;
        int i2 = 0;
        while (i2 < file2.getItemCount()) {
            T item = file2.getItem(i2);
            if (items1.contains(item)) {
                ++equalItemCount;
                items1.remove(item);
            }
            ++i2;
        }
        return Math.max(file1.getItemCount(), file2.getItemCount()) - equalItemCount;
    }

    private static class WorkItem {
        private final int pos1;
        private final int pos2;
        private final int sum;

        public WorkItem(int pos1, int pos2, int sum) {
            this.pos1 = pos1;
            this.pos2 = pos2;
            this.sum = sum;
        }

        public WorkItem up() {
            return new WorkItemU(this.pos1, this.pos2 - 1, this.sum + 1);
        }

        public WorkItem left() {
            return new WorkItemL(this.pos1 - 1, this.pos2, this.sum + 1);
        }

        public WorkItem same() {
            return new WorkItemS(this.pos1 - 1, this.pos2 - 1, this.sum);
        }

        public WorkItem diagonal() {
            return new WorkItemD(this.pos1 - 1, this.pos2 - 1, this.sum + 1);
        }

        public int hashCode() {
            return this.pos1 ^ Integer.reverseBytes(this.pos2);
        }

        public boolean equals(Object o) {
            if (!(o instanceof WorkItem)) {
                return false;
            }
            WorkItem w = (WorkItem)o;
            return w.pos1 == this.pos1 && w.pos2 == this.pos2;
        }
    }

    private static class WorkItemD
    extends WorkItem {
        public WorkItemD(int pos1, int pos2, int sum) {
            super(pos1, pos2, sum);
        }
    }

    private static class WorkItemL
    extends WorkItem {
        public WorkItemL(int pos1, int pos2, int sum) {
            super(pos1, pos2, sum);
        }
    }

    private static class WorkItemS
    extends WorkItem {
        public WorkItemS(int pos1, int pos2, int sum) {
            super(pos1, pos2, sum);
        }
    }

    private static class WorkItemU
    extends WorkItem {
        public WorkItemU(int pos1, int pos2, int sum) {
            super(pos1, pos2, sum);
        }
    }
}

