/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.base.tree;

import de.setsoftware.reviewtool.base.tree.AbstractTreeNode;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class OrderedTreeNode<K extends Comparable<K>, V>
extends AbstractTreeNode<K, V, OrderedTreeNode<K, V>> {
    private static final long serialVersionUID = 8089192927259795001L;
    private final TreeMap<K, OrderedTreeNode<K, V>> children = new TreeMap();

    private OrderedTreeNode(OrderedTreeNode<K, V> parent, V value) {
        super(parent, value);
    }

    public static <K extends Comparable<K>, V> OrderedTreeNode<K, V> createRoot(V value) {
        return new OrderedTreeNode<K, V>(null, value);
    }

    @Override
    public OrderedTreeNode<K, V> getNode(K key) {
        return this.children.get(key);
    }

    @Override
    public OrderedTreeNode<K, V> putValue(K key, V value) {
        OrderedTreeNode<K, V> child = this.children.get(key);
        if (child == null) {
            child = new OrderedTreeNode<K, V>(this, value);
            this.children.put(key, child);
        } else {
            child.setValue(value);
        }
        return child;
    }

    @Override
    public Set<Map.Entry<K, OrderedTreeNode<K, V>>> getEntries() {
        return Collections.unmodifiableSet(this.children.entrySet());
    }

    @Override
    public void removeNode(OrderedTreeNode<K, V> childNode) {
        this.children.values().remove(childNode);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OrderedTreeNode) {
            return super.equals(obj);
        }
        return false;
    }

    @Override
    protected OrderedTreeNode<K, V> getSelf() {
        return this;
    }
}

