/*
 * Decompiled with CFR 0.152.
 */
package de.setsoftware.reviewtool.base.tree;

import de.setsoftware.reviewtool.base.Pair;
import de.setsoftware.reviewtool.base.tree.TreeChildOrderStrategy;
import de.setsoftware.reviewtool.base.tree.TreeNode;
import de.setsoftware.reviewtool.base.tree.TreeNodeIterator;
import de.setsoftware.reviewtool.base.tree.TreeRootNodeStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class DepthFirstTraversalTreeNodeIterator<K, V, N extends TreeNode<K, V, N>>
implements TreeNodeIterator<K, V, N> {
    private final N root;
    private final TreeChildOrderStrategy<K, V, N> childNodeStrategy;
    private final TreeRootNodeStrategy<K, V, N> rootNodeStrategy;
    private final Iterator<Pair<List<K>, N>> it;
    private Iterator<Pair<List<K>, N>> nextLevelIt;

    public DepthFirstTraversalTreeNodeIterator(N root, TreeRootNodeStrategy<K, V, N> rootNodeStrategy, TreeChildOrderStrategy<K, V, N> childNodeStrategy) {
        this(root, Collections.emptyList(), rootNodeStrategy, childNodeStrategy);
    }

    public DepthFirstTraversalTreeNodeIterator(N root, List<K> rootPath, TreeRootNodeStrategy<K, V, N> rootNodeStrategy, TreeChildOrderStrategy<K, V, N> childNodeStrategy) {
        this.root = root;
        this.childNodeStrategy = childNodeStrategy;
        this.rootNodeStrategy = rootNodeStrategy;
        ArrayList entries = new ArrayList();
        for (Map.Entry entry : root.getEntries()) {
            ArrayList<K> childPath = new ArrayList<K>(rootPath);
            childPath.add(entry.getKey());
            entries.add(Pair.create(childPath, (TreeNode)entry.getValue()));
        }
        childNodeStrategy.finalizeNodeList(entries);
        rootNodeStrategy.insertRootNode(entries, Pair.create(rootPath, root));
        this.it = entries.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.nextLevelIt != null && this.nextLevelIt.hasNext() || this.it.hasNext();
    }

    @Override
    public Pair<List<K>, N> next() {
        assert (this.hasNext());
        if (this.nextLevelIt == null || !this.nextLevelIt.hasNext()) {
            Pair<List<K>, N> entry = this.it.next();
            if (entry.getSecond() == this.root) {
                return entry;
            }
            this.nextLevelIt = new DepthFirstTraversalTreeNodeIterator<K, V, TreeNode>((TreeNode)entry.getSecond(), entry.getFirst(), this.rootNodeStrategy, this.childNodeStrategy);
        }
        return this.nextLevelIt.next();
    }
}

